import { queryCurrent, queryUsers, homeInfo } from '@/services/user';
import localStorage from '@/utils/localStorage';

const UserModel = {
  namespace: 'user',
  state: {
    currentUser: {},
    homeInfo: {},
  },
  effects: {
    *fetch(_, { call, put }) {
      const response = yield call(queryUsers);
      yield put({
        type: 'save',
        payload: response,
      });
    },

    *fetchCurrent(_, { call, put }) {
      const response = yield call(queryCurrent);
      if (response.code === 2000) {
        localStorage.set('user', JSON.stringify(response.data));
      }
      yield put({
        type: 'saveCurrentUser',
        payload: response.data,
      });
    },
    *homeInfo(_, { call, put }) {
      const response = yield call(homeInfo);
      yield put({
        type: 'saveData',
        payload: {
          homeInfo: response.data,
        },
      });
    },
  },
  reducers: {
    saveCurrentUser(state, action) {
      return { ...state, currentUser: action.payload || {} };
    },
    saveData(state, action) {
      const data = action.payload;
      return { ...state, ...data };
    },

    changeNotifyCount(
      state = {
        currentUser: {},
      },
      action,
    ) {
      return {
        ...state,
        currentUser: {
          ...state.currentUser,
          notifyCount: action.payload.totalCount,
          unreadCount: action.payload.unreadCount,
        },
      };
    },
  },
};
export default UserModel;
