import request from '@/utils/request';
import config from '../../../config/env.config';
// import { stringify } from 'qs';
// import _ from 'lodash';

const { kdspApi } = config;
// const kdspApi = 'http://192.168.29.106:7000';

// 分页查询所有数据
export async function searchList(params, auditStatus) {
  const param = {
    ...params,
    pageIndex: params.current,
    pageSize: params.pageSize || 20,
    auditStatus,
  };
  const data = await request.post('/cancel-order/apply/page-list', {
    prefix: kdspApi,
    // data: stringify(param),
    data: param,
    // headers: {
    //   'Content-Type': 'application/x-www-form-urlencoded',
    // },
  });
  // if (data && data.data) {
  //   return {
  //     total: data.data.total,
  //     data: data.data.records,
  //   };
  // }
  return {
    total: 10,
    data: [
      { serviceNo: 1, receiverName: 1, startTime: 1649924464730 },
      { serviceNo: 2, receiverName: 2, startTime: 1649920460730 },
    ],
  };
}

// 售后单详情
export async function orderDetail(params) {
  const data = await request.get('/cancel-order/sku', {
    prefix: kdspApi,
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data.data || [];
}
// 售后审核
export async function shopAudit(params) {
  return request.post('/cancel-order/audit', {
    data: params,
    prefix: kdspApi,
  });
}
// 查询审核信息
// export async function auditInfoApi(params) {
//   return request.get('/api/kdsp/op/afs/back-info', {
//     params,
//     prefix: kdspApi,
//   });
// }

// 审核核检
export async function shopCheck(params) {
  return request.post('/api/kdsp/op/afs/shop/check', {
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    prefix: kdspApi,
  });
}
// 查询物流信息
export async function trackInfo(params) {
  const data = await request.get('/api/kdsp/op/logistics/kd100/track-list', {
    params,
    prefix: kdspApi,
  });
  if (data.businessCode === '0000') {
    return data.data;
  }
  return {};
}
