import { Button, Upload, notification } from 'antd';
import React, { useState, useEffect, useRef } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import LogisticsForm from './components/LogisticsForm';
import style from './styles.less';
import {
  queryToSend,
  queryExpress,
  getGoods,
  uploadFile,
  getLogistics,
  downTemplate,
  downOrder,
} from './service';

const TableList = props => {
  const [companys, setCompanys] = useState([]);
  const [LogisticsModalVisible, handleModalVisible] = useState(false);
  const [skuList, setSkuList] = useState([]);
  const [LogisticsData, setLogisticsData] = useState([{}]);
  const [QueryData, setQueryData] = useState({});
  const [ShowUpdateBtn] = useState([2, 5]);

  const actionRef = useRef();
  const renderContent = (record, key) =>
    record.mchOrderSkuVoList.map((item, index) => (
      <p
        className={[
          'tableContent',
          index < record?.mchOrderSkuVoList?.length - 1 ? 'border' : null,
        ].join(' ')}
      >
        {item[key]}
      </p>
    ));
  const columns = [
    {
      title: '订单ID',
      dataIndex: 'orderNo',
      key: 'orderNo',
      order: 6,
      width: 250,
      fixed: 'left',
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      key: 'skuName',
      order: 6,
      hideInTable: true,
    },
    {
      title: '交易时间',
      dataIndex: 'orderTime',
      key: 'orderTime',
      hideInSearch: true,
      width: 200,
    },
    {
      title: '收货人手机',
      dataIndex: 'receiverPhone',
      key: 'receiverPhone',
      order: 4,
      width: 150,
    },
    {
      title: '收货人姓名',
      dataIndex: 'receiverName',
      key: 'receiverName',
      order: 3,
      width: 120,
    },
    {
      title: '收货地址',
      dataIndex: 'fullAddress',
      key: 'fullAddress',
      hideInSearch: true,
      width: 350,
    },
    {
      title: '商品自编码',
      dataIndex: 'orderSkuId',
      key: 'orderSkuId',
      width: 120,
      hideInSearch: true,
      className: 'colStyle',
      render: (_, record) => renderContent(record, 'orderSkuId'),
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      key: 'skuName',
      width: 400,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'skuName'),
    },
    {
      title: '商品规格',
      dataIndex: 'skuAttr',
      key: 'skuAttr',
      width: 200,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'skuAttr'),
    },
    {
      title: '商品数量',
      dataIndex: 'count',
      key: 'count',
      width: 100,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'count'),
    },
    {
      title: '物流公司',
      dataIndex: 'expressCompanyName',
      key: 'expressCompanyName',
      width: 100,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'expressCompanyName'),
    },
    {
      title: '物流单号',
      dataIndex: 'deliveryNo',
      key: 'deliveryNo',
      width: 180,
      className: 'colStyle',
      hideInSearch: true,
      render: (_, record) => renderContent(record, 'deliveryNo'),
    },
    {
      title: '订单状态',
      dataIndex: 'orderStatus',
      key: 'orderStatus',
      width: 120,
      hideInSearch: true,
      valueEnum: {
        12: '待发货',
        13: '待收货',
        21: '订单完成',
      },
    },
    {
      title: '订单开始时间',
      dataIndex: 'beginTime',
      key: 'beginTime',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '订单结束时间',
      dataIndex: 'endTime',
      key: 'endTime',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      valueType: 'option',
      width: 150,
      fixed: 'right',
      render: (_, record) => (
        <React.Fragment>
          {ShowUpdateBtn.includes(record?.skuSource?.value) ? null : (
            <Button
              type="primary"
              style={{
                marginBottom: '10px',
              }}
              onClick={async () => {
                const skuListData = await getGoods(record?.orderId);
                let logisticsData = [{}];
                setSkuList(skuListData);
                const data = await getLogistics(record?.orderId);
                logisticsData = data.map(item => ({
                  selectedGoods: item?.skus?.map(sku => sku?.orderSkuId),
                  selectedCompany: `${item?.expressCompanyCode}-${item?.expressCompanyName}`,
                  orderNum: item?.deliveryNo,
                }));
                setLogisticsData(logisticsData);
                handleModalVisible(true);
              }}
            >
              {props.type === 2 ? '更新物流信息' : '填写物流信息'}
            </Button>
          )}
        </React.Fragment>
      ),
    },
  ];

  const reload = () => {
    handleModalVisible(false);
    if (actionRef.current) {
      actionRef.current.reload();
    }
  };

  useEffect(() => {
    const getCompanys = async () => {
      const data = await queryExpress();
      setCompanys(data);
    };
    getCompanys();
  }, []);
  const uploadProps = {
    name: 'file',
    async customRequest(info) {
      const result = await uploadFile(info.file);
      if (result.businessCode === '0000') {
        notification.success({ message: '导入成功' });
      } else {
        notification.error({ message: result.detail });
      }
    },
    accept: '.xlsx',
    showUploadList: false,
  };

  const queryToSendFn = params => {
    const transformedParam = {
      ...params,
      logisticsStatus: props.type || 1,
      startTime: params.beginTime,
      pageNo: params.current,
      pageSize: params.pageSize || 20,
    };
    setQueryData(transformedParam);
    return queryToSend(transformedParam);
  };
  const searchRender = ({ searchText, resetText }, { form }) => {
    const exportBtn = [
      <Upload {...uploadProps}>
        <Button type="primary" style={{ marginRight: '10px' }} key="export">
          导入
        </Button>
      </Upload>,
      <Button
        type="primary"
        key="exportTemplate"
        onClick={downTemplate}
        style={{ marginRight: '10px' }}
      >
        导入模板下载
      </Button>,
    ];
    return [
      <Button
        key="search"
        type="primary"
        style={{ marginRight: '10px' }}
        onClick={() => {
          // eslint-disable-next-line no-unused-expressions
          form?.submit();
        }}
      >
        {searchText}
      </Button>,
      <Button
        key="rest"
        style={{ marginRight: '10px' }}
        onClick={() => {
          // eslint-disable-next-line no-unused-expressions
          form?.resetFields();
          setQueryData({ logisticsStatus: props.type || 1 });
        }}
      >
        {resetText}
      </Button>,
      props.type === 2 ? null : [...exportBtn],
    ];
  };

  const toolBarRenderFn = () => [
    <Button
      type="primary"
      onClick={() => {
        downOrder(QueryData);
      }}
    >
      导出数据
    </Button>,
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        className={style.protable}
        actionRef={actionRef}
        request={params => queryToSendFn({ ...params })}
        columns={columns}
        rowKey={r => r.orderId}
        toolBarRender={toolBarRenderFn}
        search={{
          collapsed: false,
          optionRender: searchRender,
        }}
        bordered
        scroll={{ x: 1500 }}
      />
      <LogisticsForm
        onSubmit={reload}
        skuList={skuList}
        companys={companys}
        onCancel={() => handleModalVisible(false)}
        modalVisible={LogisticsModalVisible}
        value={LogisticsData}
      />
    </PageHeaderWrapper>
  );
};

export default TableList;
