import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Input, Modal } from 'antd';
import React, { Component } from 'react';

const { TextArea } = Input;
const FormItem = Form.Item;
// import styles from '../style.less';

class goodsManage extends Component {
  // componentDidMount() {
  //   this.props.onRef(this);
  // }

  handleOk = () => {
    const { form } = this.props;
    form.validateFields((err, values) => {
      if (!err) {
        this.props.changeSkuName(values.name);
        this.props.form.resetFields();
      }
    });
  };

  handleCancel = () => {
    this.props.form.resetFields();
    this.props.onCancle();
  };

  render() {
    const { data, visible, form } = this.props;
    const { getFieldDecorator } = form;
    return (
      <Modal title="" visible={visible} onOk={this.handleOk} onCancel={this.handleCancel}>
        <Form>
          <FormItem label="sku名称">
            {getFieldDecorator('name', {
              initialValue: data,
              rules: [
                {
                  required: true,
                  message: '请输入',
                },
              ],
            })(<TextArea autoSize={{ minRows: 2, maxRows: 6 }} allowClear />)}
          </FormItem>
        </Form>
      </Modal>
    );
  }
}

export default Form.create()(goodsManage);
