import request from '@/utils/request';
import config from '@/../config/env.config';

const { roleApi, apiPrefix } = config;

/**
 * 获取企业客户详细
 * http://yapi.quantgroups.com/project/389/interface/api/65339
 */
export async function apiEnterpriseInfo(id) {
  return request.get(`${apiPrefix}/enterprise/info?id=${id}`, {
    prefix: roleApi,
  });
}
/**
 * 添加企业客户
 * http://yapi.quantgroups.com/project/389/interface/api/65329
 */
export async function apiNewEnterprise(data) {
  return request.post(`${apiPrefix}/enterprise/save`, {
    data,
    prefix: roleApi,
  });
}
/**
 * 编辑企业客户
 * http://yapi.quantgroups.com/project/389/interface/api/65334
 */
export async function apiEditEnterprise(data) {
  return request.post(`${apiPrefix}/enterprise/update`, {
    data,
    prefix: roleApi,
  });
}

/**
 * 查询自提点列表
 * http://yapi.quantgroups.com/project/389/interface/api/65494
 */
export async function apiEnterprisePickSelf() {
  return request.get(`${apiPrefix}/selfPickUpLocation/list`, {
    prefix: roleApi,
  });
}
