/* eslint-disable no-shadow */

import { Button, notification, Modal, Spin } from 'antd';
import React, { useRef, useState } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import { saveAs } from 'file-saver';
import { format } from 'date-fns';
import ToExamineModal from './ToExamine';
import { columns, toolBarRender } from './data';
import {
  query,
  selfPaymentExport,
  selfPaymentexportDetail,
  settlement,
  merchantView,
} from './service';

const { confirm } = Modal;

const PaymentMange = () => {
  const actionRef = useRef();
  const formRef = useRef();
  const [toExamineData, settoExamineData] = useState({});
  const [loading, setloading] = useState(false);
  const [status, setstatus] = useState(1);
  const [pages, setpages] = useState({});
  const [rest, setrest] = useState(1);
  const [toExamineModalVisibel, setToExamineModalVisibel] = useState(false);

  const reload = () => {
    if (actionRef.current) {
      actionRef.current.reload();
    }
  };

  // 下载账单付款单明细
  const exportDetail = async params => {
    setloading(true);
    const data = await selfPaymentexportDetail(params);
    if (data) {
      const blob = new Blob([data]);
      saveAs(blob, `账单付款单明细-${format(new Date(), 'yyyyMMddHHmmss')}.xlsx`);
    } else {
      notification.error({ message: '下载失败' });
    }
    setloading(false);
  };
  // 申请结算
  const applySettlement = async params => {
    setloading(true);
    const data = await settlement(params);
    if (data.businessCode === '0000') {
      reload();
      notification.success({ message: '申请成功' });
    }
    setloading(false);
  };
  const showConfirm = params => {
    confirm({
      title: '申请结算',
      content: '现在结算？',
      onOk() {
        applySettlement(params);
      },
    });
  };
  // 查看发票
  const invoiceDetail = async params => {
    const data = await merchantView(params);
    if (data.businessCode === '0000') {
      settoExamineData({ ...data.data });
      setToExamineModalVisibel(true);
    }
  };
  // 0申请结算 1上传发票 2查看发票 3下载账单付款单明细
  const edit = async (status, { id }) => {
    if (status === 0) {
      showConfirm(id);
    } else if (status === 1) {
      setstatus(status);
      settoExamineData({ id });
      setToExamineModalVisibel(true);
    } else if (status === 2) {
      setstatus(status);
      invoiceDetail(id);
    } else if (status === 3) {
      exportDetail(id);
    }
  };

  const onColse = () => {
    if (status === 1) {
      reload();
    }
    setToExamineModalVisibel(false);
  };

  const onExport = async () => {
    const params = formRef.current.getFieldsValue();
    setloading(true);
    if (params?.dateTimeRange?.[0]) {
      const data = await selfPaymentExport(params);
      const blob = new Blob([data]);
      saveAs(blob, `付款单导出数据-${format(new Date(), 'yyyyMMddHHmmss')}.xlsx`);
    } else {
      notification.error({ message: '付款单开始时间不能为空' });
    }
    setloading(false);
  };

  const onToolBarRender = toolBarRender();

  const res = {
    edit,
  };

  const searchRender = ({ searchText, resetText }, { form }) => [
    <Button
      key="search"
      type="primary"
      style={{ marginRight: '10px' }}
      onClick={() => {
        // eslint-disable-next-line no-unused-expressions
        form?.submit();
      }}
    >
      {searchText}
    </Button>,
    <Button
      key="rest"
      style={{ marginRight: '10px' }}
      onClick={() => {
        // eslint-disable-next-line no-unused-expressions
        form?.resetFields();
        setrest(2);
        reload();
      }}
    >
      {resetText}
    </Button>,
    <Button
      key="export"
      type="primary"
      style={{ marginRight: '10px' }}
      onClick={() => {
        // eslint-disable-next-line no-unused-expressions
        onExport();
      }}
    >
      导出
    </Button>,
  ];

  return (
    <Spin tip="处理中..." spinning={loading} delay={100}>
      <PageHeaderWrapper>
        <ProTable
          actionRef={actionRef}
          formRef={formRef}
          request={params => {
            const { current, pageSize } = params;
            setpages({ current, pageSize });
            let param = {};
            if (rest === 2) {
              param = { current, pageSize };
            } else {
              param = params;
            }
            setrest(1);
            return query({ ...param });
          }}
          columns={columns(res, pages)}
          rowKey={r => r.id}
          search={{
            collapsed: false,
            optionRender: searchRender,
          }}
          bordered
          toolBarRender={onToolBarRender}
          scroll={{ x: '1700px' }}
        />

        <ToExamineModal
          visible={toExamineModalVisibel}
          toExamineData={toExamineData}
          status={status}
          close={() => {
            onColse();
          }}
        />
      </PageHeaderWrapper>
    </Spin>
  );
};

export default PaymentMange;
