import React, { forwardRef, useImperativeHandle, useState } from 'react';
import { Modal } from 'antd';
import { RoleInfoComponent } from '../../../Role/RoleInfo';

const RolePermissionsModal = (props, ref) => {
  const [visible, setVisible] = useState(false);
  const [roleInfo, setRoleInfo] = useState({});

  const open = record => {
    setVisible(true);
    console.log('record', record);
    setRoleInfo(record);
  };

  const onCancel = () => {
    setVisible(false);
  };

  useImperativeHandle(ref, () => ({
    open,
  }));

  const modalProps = {
    width: 600,
    title: '查看角色',
    visible,
    footer: null,
    onCancel,
  };

  const roleProps = {
    id: roleInfo.id,
    submittable: false,
    readyonly: true,
    height: '500px',
    wrapperCol: {
      span: 18,
    },
  };

  console.log(roleProps);

  return (
    <>
      {visible ? (
        <Modal {...modalProps}>
          <RoleInfoComponent {...roleProps} />
        </Modal>
      ) : null}
    </>
  );
};

export default forwardRef(RolePermissionsModal);
