import { stringify } from 'querystring';
import _ from 'lodash';
import request from '@/utils/request';
import { saveAs } from 'file-saver';
import { format } from 'date-fns';
import config from '../../../../config/env.config';

// 待发货订单
export async function queryToSend(params) {
  try {
    const {
      data: { current, records, total, size },
    } = await request.post('/api/kdsp/op/mch-order/list-v2', {
      prefix: config.kdspApi,
      data: stringify(_.omitBy(params, v => !v)),
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });
    return {
      current,
      data: records.map(v => ({ ...v, logisticsStatus: `_${v.logisticsStatus}` })),
      total,
      pageSize: size,
    };
  } catch (error) {
    return {};
  }
}

// 快递公司
export async function queryExpress() {
  try {
    const { data } = await request.get('/api/kdsp/op/express/list', {
      prefix: config.kdspApi,
    });
    return data;
  } catch (error) {
    return {};
  }
}

export async function updateExpress(params) {
  return request.post('/api/kdsp/op/mch-order/update-express-info', {
    prefix: config.kdspApi,
    data: params,
  });
}

export async function getGoods(orderId) {
  const { data } = await request.get(`/api/kdsp/op/mch-order/skus?orderId=${orderId}`, {
    prefix: config.kdspApi,
  });
  return data;
}
export async function getLogistics(orderId) {
  const { data } = await request.get(`/api/kdsp/op/mch-order/logistics-skus?orderId=${orderId}`, {
    prefix: config.kdspApi,
  });
  return data;
}
export async function uploadFile(file) {
  const params = new FormData();
  params.append('file', file);
  const data = await request.post('/api/kdsp/op/mch-order/order-logistics-batch-import', {
    data: params,
    prefix: config.kdspApi,
  });
  return data;
}
export function downTemplate() {
  window.location.href =
    // 'https://kdspstatic.q-gp.com/%E8%AE%A2%E5%8D%95%E7%89%A9%E6%B5%81%E4%BF%A1%E6%81%AF%E5%AF%BC%E5%85%A5%E6%A8%A1%E6%9D%BF-v1.xlsx';
    'https://kdspstatic.q-gp.com/order_import_templatev2.xlsx';
}
export async function downOrder(params) {
  const data = await request.post('/api/kdsp/op/mch-order/order-export', {
    data: stringify(_.omitBy(params, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    prefix: config.kdspApi,
    responseType: 'arrayBuffer',
  });
  const blob = new Blob([data]);
  saveAs(blob, `商户订单列表-${format(new Date(), 'yyyyMMddHHmmss')}.xlsx`);
}
export async function getLogisticsInfo(companyCode, logisticsNo) {
  const { data } = await request.get(
    `/api/kdsp/op/logistics/kd100/track-list?companyCode=${companyCode}&logisticsNo=${logisticsNo}`,
    {
      prefix: config.kdspApi,
    },
  );
  return data;
}
// 京东企业购和京东开普勒物流信息
export async function getJDLogisticsInfo(orderSkuId) {
  const { data } = await request.get(`/api/kdsp/op/logistics/track-list?orderSkuId=${orderSkuId}`, {
    prefix: config.kdspApi,
  });
  return data;
}
// 批量发货订单
export async function queryToBatchSend(params) {
  const transformedParam = {
    pageNo: params.current,
    pageSize: params.pageSize || 20,
    startTime: params.dateTimeRange?.[0],
    endTime: params.dateTimeRange?.[1],
    status: params?.status ?? 99,
    batchNo: params.batchNo,
  };
  const {
    data: { current, records, total, size },
  } = await request.get('/api/kdsp/op/mch-order/delivery-batch-list', {
    prefix: config.kdspApi,
    params: _.omitBy(transformedParam, v => !v),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return {
    current,
    data: records.map(v => ({ ...v })),
    total,
    pageSize: size,
  };
}
export async function downUploadeOrder(params) {
  const data = await request.get('/api/kdsp/op/mch-order/delivery-batch-order-downLoad', {
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    prefix: config.kdspApi,
    responseType: 'arrayBuffer',
  });
  const blob = new Blob([data]);
  const status = {
    0: '失败数据',
    1: '成功数据',
    2: '全部数据',
  };
  saveAs(blob, `批量发货-${status[params.status]}-${format(new Date(), 'yyyyMMddHHmmss')}.xlsx`);
}
// 延迟发货
export function apiDelayDeliverGoods(data) {
  return request.post('/api/kdsp/order/operation/record/create', {
    data,
    prefix: config.kdspApi,
  });
}

/**
 * 多物流发货-查询多物流订单信息
 * @param {*} params
 * @returns
 * @see http://yapi.quantgroups.com/project/389/interface/api/45840
 */
export function apiQueryOrderInfo(params) {
  // return new Promise(resolve => {
  //   setTimeout(() => {
  //     resolve({
  //       packageList: [
  //         {
  //           expressCompanyCode: 'yunda',
  //           expressCompanyName: '',
  //           expressNo: 'YUNDA012345678',
  //           serialNumber: '0011223344',
  //           skuInfoList: [
  //             {
  //               skuNo: ['529355424931841'],
  //               quantity: '2',
  //             },
  //             {
  //               skuNo: ['530724210084865'],
  //               quantity: '12',
  //             },
  //           ],
  //         },
  //         {
  //           expressCompanyCode: 'yunda',
  //           expressCompanyName: '',
  //           expressNo: 'YUNDA012345678',
  //           serialNumber: '0011223344',
  //           skuInfoList: [
  //             {
  //               skuNo: ['529355424931841'],
  //               quantity: '2',
  //             },
  //           ],
  //         },
  //       ],
  //     });
  //   }, 1000);
  // });
  return request.get('/api/merchants/orders/deliveries/packages/detail', {
    params,
    prefix: config.kdspApi,
  });
}
/**
 * 多物流发货-新建发货/更新发货信息
 * @param {*} data
 * @returns
 * @see http://yapi.quantgroups.com/project/389/interface/api/45816
 */
export function apiDeliveriesAdd(data) {
  return request.post('/api/merchants/orders/deliveries/add', {
    data,
    prefix: config.kdspApi,
  });
}
