import { APP_CODE } from '@/utils/constants';
import request from '@/utils/request';
import config from '../../config/env.config';

const { kdspApi } = config;

export async function queryCurrent() {
  // 查询用户信息
  return request.post('/v2/oauth/currentuserinfo');
}

// 查询商户信息
export const apiBusinessDetail = () =>
  request.get('/api/merchants/suppliers/pops/detail', { prefix: kdspApi });

export async function homeInfo() {
  // 查询主页信息
  return request.post('/home/info');
}

export function getUserPermissions(roleId) {
  if (roleId) {
    return request.post(`/v2/resource/${APP_CODE}/${roleId}`);
  }
  return request.post(`/v2/resource/${APP_CODE}`);
}
