import { Button, Popconfirm, notification } from 'antd';
import React, { useRef, useEffect, useState } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import { connect } from 'umi';
import { columns } from './data';
import AddArea from './addArea';
import { searchList, addressTree } from './services';
import { DISTRIBUTION_AREA } from '@/../config/permission.config';

const TableList = props => {
  const { permissions } = props;
  const canEditable = permissions[DISTRIBUTION_AREA.EDITABLE];
  const [visible, setVisible] = useState(false);
  const [templateData, settemplateData] = useState('');
  const actionRef = useRef();
  const reload = () => {
    setVisible(false);
    if (actionRef.current) {
      actionRef.current.reload();
    }
  };
  const setaArea = () => {
    setVisible(true);
    settemplateData({ status: 0, list: [] });
  };
  const edit = async (status, { id, templateName }) => {
    const data = await addressTree({ templateId: id });
    if (data.businessCode === '0000') {
      settemplateData({ status, list: data.data, id, templateName });
      setVisible(true);
    }
  };
  const res = {
    edit,
    canEditable,
  };
  useEffect(() => {}, []);
  return (
    <PageHeaderWrapper>
      <ProTable
        actionRef={actionRef}
        columns={columns(res)}
        request={searchList}
        rowKey="id"
        bordered
        search={false}
        options={false}
        toolBarRender={() => [
          canEditable && (
            <Button key="3" type="primary" onClick={setaArea}>
              {' '}
              添加
            </Button>
          ),
        ]}
      />
      {visible && <AddArea visible={visible} onSubmit={reload} templateData={templateData} />}
    </PageHeaderWrapper>
  );
};

export default connect(({ menu }) => ({
  permissions: menu.permissions,
}))(TableList);
