import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, Input, Select, Cascader, Tag, notification } from 'antd';
import React, { useState, useEffect } from 'react';
import { el } from 'date-fns/locale';
import { areaList, getAddTemplate, forbiddenAddress } from '../services';

const { Option } = Select;

const AddAreaModal = props => {
  const {
    visible,
    form: { getFieldDecorator, validateFields, resetFields, setFieldsValue },
    templateData,
  } = props;
  const [addList, setAddList] = useState([]);
  const [selectedList, setSelectedList] = useState([]);
  const [selected, setSelect] = useState([]);
  const formItemLayout = {
    labelCol: {
      span: 6,
    },
    wrapperCol: {
      span: 16,
    },
  };
  const getAreaList = async () => {
    if (!addList.length) {
      const data = await areaList();
      const newData = [];
      data.map(item =>
        newData.push({
          label: item.addrName,
          value: item.addrId,
          addressId: item.addrId,
          addressLevel: item.addrLevel,
          isLeaf: item.addrLevel === 4,
        }),
      );
      setAddList(newData);
    }
  };

  const onChange = (value, selectedOptions) => {
    setSelect([...selectedOptions]);
  };
  // 加载
  const loadData = async selectedOptions => {
    const targetOption = selectedOptions.slice(-1)[0];
    targetOption.loading = true;
    const data = await areaList({ parentId: targetOption.addressId });
    if (!data.length) {
      targetOption.loading = false;
    } else {
      const newData = [];
      data.map(itemData =>
        newData.push({
          label: itemData.addrName,
          value: itemData.addrId,
          addressId: itemData.addrId,
          addressLevel: itemData.addrLevel,
          isLeaf: false,
        }),
      );
      targetOption.children = newData;
      targetOption.loading = false;
      setAddList([...addList]);
    }
  };
  // 限制区域删除
  const preventDefault = val => {
    const newArr = selectedList.filter(item => item !== val);
    setSelectedList([...newArr]);
  };
  const onCancel = () => {
    setSelectedList([]);
    resetFields();
    setSelect([]);
    props.onSubmit();
  };
  const handleOk = async () => {
    const { length } = selectedList;
    // if (!selectedList.length) {
    //   notification.error({ message: '请选择限制区域！' });
    //   return;
    // }
    validateFields(async (error, fieldsValue) => {
      const newData = [];
      selectedList.map(itemData =>
        newData.push({
          addressId: itemData.addressId,
          addressLevel: itemData.addressLevel,
          addressName: itemData.addressName,
        }),
      );
      if (!error) {
        if (props.templateData.status) {
          const data = await forbiddenAddress({
            templateId: props.templateData.id,
            templateName: fieldsValue.templateName,
            areaList: newData,
          });
          if (data.businessCode === '0000') {
            notification.success({ message: '编辑成功！' });
            onCancel();
          }
        } else {
          const data = await getAddTemplate({
            templateName: fieldsValue.templateName,
            areaList: newData,
          });
          if (data.businessCode === '0000') {
            notification.success({ message: '添加成功！' });
            onCancel();
          }
        }
      }
    });
  };
  // 判断是否重复
  const getChilds = select => {
    const reslutData = selectedList.filter(
      item =>
        !select.addressName.includes(item.addressName) &&
        !item.addressName.includes(select.addressName),
    );
    reslutData.push(select);
    return reslutData;
  };

  const onPopupVisibleChange = labels => {
    if (!labels && selected?.length) {
      const select = selected.slice(-1)[0];
      const arr = selected.map(x => x.label);
      select.addressName = arr.join('/');
      const reslutData = getChilds(select);
      // 用中文字符排序
      const resultArray = reslutData.sort((param1, param2) =>
        param1.addressName.localeCompare(param2.addressName, 'zh'),
      );
      setSelectedList([...resultArray]);
      setSelect([]);
    }
  };
  useEffect(() => {
    getAreaList();
    if (props.templateData) {
      setSelectedList(props.templateData.list);
    }
  }, [props.templateData]);
  useEffect(() => {
    // console.log(selectedList)
  }, [selectedList]);
  return (
    <Modal
      title={props.templateData.status ? '编辑限制区域配送模板' : '添加限制区域配送模板'}
      visible={visible}
      width="500px"
      onCancel={() => onCancel()}
      onOk={() => handleOk()}
    >
      <Form {...formItemLayout}>
        <Form.Item label="模板名称">
          {getFieldDecorator('templateName', {
            rules: [{ required: true, message: '请输入模板名称!' }],
            initialValue: templateData.templateName,
          })(<Input placeholder="请填写模板名称" maxLength={20} />)}
        </Form.Item>
        <Form.Item label="限制配送区域">
          {getFieldDecorator('name')(
            <Cascader
              options={addList}
              loadData={loadData}
              onChange={(val, label) => onChange(val, label)}
              allowClear={false}
              changeOnSelect
              onDropdownVisibleChange={onPopupVisibleChange}
            />,
          )}
          {selectedList?.map((selItem, selIndex) => (
            <Tag closable key={selItem.addressId} onClose={() => preventDefault(selItem)}>
              {selItem.addressName}
            </Tag>
          ))}
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default Form.create()(AddAreaModal);
