import React from 'react';
import { Select, Form, InputNumber, Input, Button } from 'antd';
import commonStyle from '../common.less';

export const WrapperContainer = props => (
  <div className={commonStyle.container}>{props.children}</div>
);

/**
 * title 组件
 * value 可以传入多种类型的值
 * onChange只会回调 number|undefined 类型
 * 当isNaN(Number(value)) 为true的时候，代表选择默认类型
 * 当选择默认类型的时候，onChange会回调undefined
 * @param props
 */

export const Title = props => (
  <div className={commonStyle.title}>
    <h3>{props.title}</h3>
  </div>
);

export const SelectTemplate = props => {
  const {
    value,
    onChange,
    formName,
    noSty,
    defaultOptionName,
    dataList,
    fieldNames,
    ...resetProps
  } = props;
  if (!dataList.length) {
    return null;
  }
  const selectTemp = (
    <Select allowClear {...resetProps}>
      {defaultOptionName ? <Select.Option value={0}>{defaultOptionName}</Select.Option> : null}
      {dataList.map((item, index) => {
        const val = fieldNames ? item[fieldNames.value] : item;
        const lab = fieldNames ? item[fieldNames.label] : item;
        return (
          <Select.Option key={val} value={val}>
            {lab}
          </Select.Option>
        );
      })}
    </Select>
  );

  return formName ? (
    <Form.Item noStyle={noSty} name={formName} key={formName}>
      {selectTemp}
    </Form.Item>
  ) : (
    selectTemp
  );
};

export const CreateFormInput = props => {
  const { title, record, dataIndex, rowIndex, onClick, type, ...options } = props;
  if (type === 'input') {
    return <Input placeholder={title} {...options} />;
  }
  if (type === 'option') {
    return (
      <>
        {record.skuLink && (
          <Button type="primary" size="small" onClick={() => onClick('cloneImg', record)}>
            拉图片
          </Button>
        )}
        {props.isJDGoods && (
          <Button
            type="primary"
            size="small"
            onClick={() => onClick('updateName', { ...record, dataIndex, rowIndex })}
            disabled={props.disabled}
          >
            修改sku名称
          </Button>
        )}
      </>
    );
  }

  return <InputNumber placeholder={title} {...options} />;
};
