export const formItemLayout = {
  labelCol: {
    sm: { span: 3 },
  },
  wrapperCol: {
    sm: { span: 16 },
  },
};

export const TaskList = [
  {
    name: '实体商品',
    type: 1,
    desc: '物流发货',
  },
  {
    name: '虚拟商品',
    type: 2,
    desc: '无需物流',
  },
  {
    name: '电子卡卷',
    type: 3,
    desc: '无需物流',
  },
  {
    name: '服务类商品',
    type: 4,
    desc: '无需物流',
  },
];

export const WeeksList = [
  {
    name: '法定节假日',
    value: 8,
  },
  {
    name: '周一',
    value: 1,
  },
  {
    name: '周二',
    value: 2,
  },
  {
    name: '周三',
    value: 3,
  },
  {
    name: '周四',
    value: 4,
  },
  {
    name: '周五',
    value: 5,
  },
  {
    name: '周六',
    value: 6,
  },
  {
    name: '周日',
    value: 7,
  },
];

export const StaticColumns = customer => [
  {
    title: '供货价',
    dataIndex: 'supplyPrice',
    editable: true,
    batchRole: [1, 2, 3],
    roleProps: {
      precision: 2,
      min: 0,
    },
    disabled: customer.isJDGoods || customer.isService,
  },
  {
    title: '佣金费率',
    dataIndex: 'commissionRate',
    editable: true,
    role: [3],
  },
  {
    title: '市场价',
    dataIndex: 'marketPrice',
    editable: true,
    batchRole: [1, 2, 3],
    roleProps: {
      precision: 2,
      min: 0,
    },
    disabled: customer.isService,
  },
  {
    title: '重量(kg)',
    dataIndex: 'weight',
    editable: true,
    batchRole: [1],
    batchProps: {
      precision: 3,
      max: 999999.999,
    },
    disabled: customer.isService,
  },
  {
    title: '销售价',
    dataIndex: 'salePrice',
    editable: true,
    role: [],
  },
  {
    title: '库存',
    dataIndex: 'stock',
    editable: true,
    role: [3],

    // disabled: customer.isService,
  },
  {
    title: '库存',
    dataIndex: 'productStock',
    editable: true,
    role: [1, 2],
    batchRole: [1, 2],
    batchProps: {
      precision: 0,
      step: 1,
      // eslint-disable-next-line radix
      formatter: val => parseInt(val, '10') || '',
    },
    roleProps: {
      precision: 2,
      min: 0,
    },
    disabled: customer.isService,
  },
  {
    title: '库存预警阈值',
    dataIndex: 'productStockWarning',
    editable: true,
    batchRole: [1],
    role: [1],
    disabled: customer.isService,
  },
  {
    title: '商品自编码',
    dataIndex: 'thirdSkuNo',
    editable: true,
    role: [1, 2],
    inputType: 'input',
    disabled: customer.isService,
  },
  {
    title: '京东链接',
    dataIndex: 'skuLink',
    editable: true,
    role: [1, 2],
    inputType: 'input',
    disabled: customer.isService,
  },
  {
    title: '操作',
    editable: true,
    dataIndex: 'option',
    role: [1, 2],
    inputType: 'option',
    roleProps: {
      isJDGoods: customer.isJDGoods,
      min: 0,
    },
    disabled: customer.isService,
  },
];
