import React from 'react';
import { Image as ImageComponent, Button } from 'antd';
import { FormOutlined } from '@ant-design/icons';

export const repastTypeList = [
  {
    value: 1,
    label: '外卖',
  },
  {
    value: 2,
    label: '自助餐',
  },
  {
    value: 4,
    label: '到店',
  },
];

export const columns = props => [
  {
    title: '微店ID',
    key: 'shopId',
    dataIndex: 'shopId',
    align: 'center',
  },
  {
    title: '微店名称',
    key: 'shopName',
    dataIndex: 'shopName',
    align: 'center',
  },
  {
    title: '餐饮类型',
    key: 'mealType',
    dataIndex: 'mealType',
    align: 'center',
    render: (_, row) => {
      const status = !row?.pickselfName;
      const isArray = Array.isArray(row?.mealType);
      if (isArray) {
        return (
          <Button type="text" disabled={status} onClick={() => props.editRepastType(row)}>
            {row.mealType?.map((item, index) => (
              <span>{repastTypeList.find(itm => itm.value === item)?.label}&nbsp;</span>
            ))}
            <FormOutlined />
          </Button>
        );
      }
      return '/';
    },
  },
  {
    title: '所属企业取餐点',
    key: 'pickselfName',
    dataIndex: 'pickselfName',
    align: 'center',
    render: (text, record) => {
      if (record.pickselfName?.length) {
        return text.map((item, index) => (
          <span>
            {item}
            {index < record.pickselfName.length - 1 && ','}
          </span>
        ));
      }
      return '/';
    },
  },
  {
    title: '修改人',
    key: 'updatedBy',
    dataIndex: 'updatedBy',
    align: 'center',
  },
  {
    title: '修改时间',
    key: 'createdAt',
    dataIndex: 'createdAt',
    align: 'center',
  },
  {
    title: '操作',
    dataIndex: 'option',
    valueType: 'option',
    align: 'center',
    key: 'option',
    render: (_, row) => (
      <Button type="link" disabled={row?.pickselfName?.length} onClick={() => props.delShop(row)}>
        删除
      </Button>
    ),
  },
];
