import React from 'react';
import { BetaSchemaForm } from '@ant-design/pro-components';
import { brandInfoColumn } from '../staticData.js';
import { layout } from '@/utils/bll';

const BrandInfo = props => {
  const refForm = React.useRef();
  const { actionStatus, brandId } = props;
  const closeModal = v => {
    !v && props.onClose();
  };
  const submitForm = async values => {
    console.log(values);
  };

  const getInfo = () =>
    Promise.resolve({
      imageList: ['https://img.yzcdn.cn/vant/cat.jpeg', 'https://img.yzcdn.cn/vant/cat.jpeg'],
    });

  const config = { actionStatus };

  return (
    <BetaSchemaForm
      layoutType="ModalForm"
      title="品牌信息"
      open={props.visible}
      width="600px"
      modalProps={{
        maskClosable: false,
        destroyOnClose: true,
      }}
      request={getInfo}
      formRef={refForm}
      onOpenChange={closeModal}
      layout="horizontal"
      {...layout}
      onFinish={submitForm}
      columns={brandInfoColumn(config)}
    />
  );
};

export default BrandInfo;
