import request from '@/utils/request';
import config from '@/../config/env.config';

const { kdspApi, goodsApi } = config;

/**
 * 分页查询所有品牌列表
 * http://yapi.quantgroups.com/project/389/interface/api/66404
 */
export async function apiBrandList(params) {
  const param = {
    ...params,
    pageNo: params.current,
  };
  const [data] = await request.post(`${goodsApi}/api/merchants/brands/list`, param, {
    emulateJSON: true,
  });
  if (data) {
    return {
      total: data.total,
      data: data.records,
    };
  }
  return {
    total: 0,
    data: [],
  };
}

/**
 * 添加品牌
 * http://yapi.quantgroups.com/project/389/interface/api/66389
 * */
export async function apiCreateBrand(params) {
  return request.post(`${goodsApi}/api/merchants/brands/add`, params);
}

/**
 * 编辑品牌
 * http://yapi.quantgroups.com/project/389/interface/api/66394
 */
export async function apiEditBrand(params) {
  return request.post(`${goodsApi}/api/merchants/brands/edit`, params);
}

/**
 * 查询品牌信息
 * http://yapi.quantgroups.com/project/389/interface/api/66409
 * */
export async function apiBrandDetail(params) {
  return request.get(`${goodsApi}/api/merchants/brands/detail`, params);
}
