import { Button, Select } from 'antd';
import React, { useRef, useEffect, useState } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import { Link } from 'umi';
import styles from './index.less';
import { query, supplier, downDetail } from './services';

const { Option } = Select;

const TableList = () => {
  const [supplierList, setSupplierList] = useState([]);
  const [shopId, setShopId] = useState(null);
  const actionRef = useRef();

  useEffect(() => {
    async function fetchData() {
      const data = await supplier();
      setSupplierList(data);
    }
    fetchData();
  }, []);
  const changeSupplier = res => {
    setShopId(res);
  };
  const reload = type => {
    if (type) {
      setShopId(null);
    }
    actionRef.current.reload();
  };

  const down = ({ batchNo }) => {
    downDetail({ batchNo });
  };

  const columns = [
    {
      title: '对账批次号',
      dataIndex: 'batchNo',
      key: 'batchNo',
      hideInSearch: true,
    },
    {
      title: '交易日期',
      dataIndex: 'tradeDate',
      key: 'tradeDate',
      hideInSearch: true,
    },
    {
      title: '交易日期',
      dataIndex: 'dateRange',
      key: 'dateRange',
      valueType: 'dateRange',
      hideInTable: true,
    },
    {
      title: '供应商名称',
      dataIndex: 'shopId',
      key: 'shopId',
      hideInTable: true,
      valueType: 'select',
      renderFormItem: () => (
        <Select onChange={changeSupplier} value={shopId} allowClear>
          {supplierList.map(item => (
            <Option value={item.id}>{item.name}</Option>
          ))}
        </Select>
      ),
    },
    {
      title: '供应商名称',
      dataIndex: 'supplierName',
      key: 'supplierName',
      hideInSearch: true,
    },
    {
      title: '我方对账条数',
      dataIndex: 'ownCount',
      key: 'ownCount',
      hideInSearch: true,
    },
    {
      title: '三方对账条数',
      dataIndex: 'thirdCount',
      key: 'thirdCount',
      hideInSearch: true,
    },
    {
      title: '对账成功条数',
      dataIndex: 'succCount',
      key: 'succCount',
      hideInSearch: true,
    },
    {
      title: '对账状态',
      dataIndex: 'status',
      key: 'status',
      valueEnum: {
        1: '平',
        2: '不平',
      },
    },
    {
      title: '操作',
      dataIndex: 'option',
      key: 'option',
      valueType: 'option',
      width: 120,
      render: (_, row) => [
        <Link
          to={{
            pathname: '/reconciliation/detail',
            query: {
              batchNo: row.batchNo,
            },
          }}
        >
          <Button key="edit" type="primary">
            查看详情
          </Button>
        </Link>,
      ],
    },
    {
      title: '下载',
      dataIndex: 'townName',
      key: 'townName',
      width: 100,
      hideInSearch: true,
      render: (_, row) => [
        <Button
          key="edit"
          type="primary"
          onClick={() => {
            down(row);
          }}
        >
          下载
        </Button>,
      ],
    },
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        className={styles.protable}
        actionRef={actionRef}
        columns={columns}
        params={{ shopId }}
        request={res => query(res)}
        rowKey="id"
        bordered
        scroll={{ x: 1500 }}
        search={{
          collapsed: false,
        }}
        onReset={() => reload('reset')}
      />
    </PageHeaderWrapper>
  );
};

export default TableList;
