import React, { useContext } from 'react';
import { TaskList } from '../config';
import { ServiceContext } from '../context';
import commonStyle from '../common.less';

export const TaskTypeSelect = props => {
  const customer = useContext(ServiceContext);
  const selectTabs = task => {
    if (!customer.isEdit) {
      props.onChange(task);
    }
  };

  return (
    <div className={commonStyle.prodcutContent}>
      {TaskList.map(task => {
        const activeClassName = props.productType === task.type ? commonStyle.activeCard : '';
        return (
          <dl
            key={task.type}
            onClick={() => selectTabs(task)}
            className={`${commonStyle.productCard} ${activeClassName}`}
          >
            <dd className="prodcut-name">{task.name}</dd>
            <dd className="prodcut-desc">({task.desc})</dd>
          </dl>
        );
      })}
    </div>
  );
};
