import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { goodsApi, kdspApi } = config;
const headers = {
  'Content-Type': 'application/x-www-form-urlencoded',
};

export const merchantUpload = async files => {
  const params = new FormData();
  files.forEach(file => params.append('file', file));
  const data = await request.post('/image/api/merchant/upload', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

export const getProductDetail = id =>
  request.post('/product/api/merchant/detail', {
    prefix: goodsApi,
    params: { id },
    headers,
  });

export const merchantCategoryGetAll = () =>
  request.post('/product/category/api/merchant/getAll', {
    prefix: goodsApi,
  });

// 获取商品品牌
export const merchantBrandList = () =>
  request.post('/product/brand/api/merchant/list', {
    prefix: goodsApi,
  });

// 获取规格列表
export const merchantSpecList = () =>
  request.post('/product/spec/api/merchant/list', {
    prefix: goodsApi,
  });

// 查询供应商售后地址
export const afterSalesAddrsPage = () => {
  const params = {
    pageSize: 100,
    pageNo: 1,
  };
  const data = request.post('/api/kdsp/supplier/after-sales-addrs-page', {
    prefix: kdspApi,
    data: stringify(_.omitBy(params, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
};

export const merchantgetJdPicList = async params => {
  const { data } = await request.post('/product/api/merchant/item/getJdPicList', {
    data: stringify(params),
    prefix: goodsApi,
    headers,
  });
  return data;
};

export const merchantProductAdd = data =>
  request.post('/product/api/merchant/add', {
    prefix: goodsApi,
    data,
  });
