import { InputNumber, Input, Modal, Button, Form, Table } from 'antd';
import React, {
  useContext,
  createContext,
  useEffect,
  useState,
  forwardRef,
  useImperativeHandle,
} from 'react';
import { ServiceContext } from '../context';
import { CreateFormInput } from './CommonTemplate';
import UUID from '../../../utils/uuid';

const UpdateSkuName = ({ skuVisble, value, confirmEvent, cancelEvent }) => {
  const [skuForm] = Form.useForm();

  const handleCancel = () => {
    skuForm.resetFields();
    cancelEvent();
  };
  const handleSaveEvent = async () => {
    try {
      const result = await skuForm.validateFields();
      confirmEvent({ skuName: result.skuName, rowIndex: value.rowIndex });
      handleCancel();
    } catch (error) {
      console.log(error);
    }
  };
  return (
    <Modal title="修改SKU名称" visible={skuVisble} onOk={handleSaveEvent} onCancel={handleCancel}>
      <Form form={skuForm} name="skuRegister">
        <Form.Item
          label="sku名称"
          key="skuName"
          name="skuName"
          initialValue={value.skuName}
          rules={[{ required: true, message: '请输入sku名称！' }]}
        >
          <Input.TextArea autoSize={{ minRows: 2, maxRows: 6 }} allowClear />
        </Form.Item>
      </Form>
    </Modal>
  );
};

const EditableContext = createContext(null);
const EditableRow = ({ index, ...props }) => <tr {...props} />;
const EditableCell = props => {
  const {
    rowIndex,
    title,
    editable,
    children,
    dataIndex,
    record,
    roleProps,
    handleSave,
    roleHidden,
    rowOnClickEvent,
    roleRules = {},
    ...restProps
  } = props;

  // console.log('==============>', props);
  const form = useContext(EditableContext);
  const customer = useContext(ServiceContext);
  const save = async () => {
    try {
      const tableList = form.getFieldValue('tableList');
      handleSave(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };
  const onClickEvent = (type, row) => {
    // 点击拉取京东图片功能
    if (type === 'cloneImg') {
      customer.onEventBus(type, row);
      return;
    }

    // 修改sku名称
    if (type === 'updateName') {
      rowOnClickEvent(row);
    }

    // console.log(type, row);
  };

  const childNode = (
    <Form.Item
      style={{ margin: 0 }}
      hidden={roleHidden}
      name={['tableList', rowIndex, dataIndex]}
      rules={[{ required: roleRules.required, message: `请输入${title}.` }]}
    >
      {editable ? (
        <CreateFormInput
          {...roleProps}
          title={title}
          rowIndex={rowIndex}
          dataIndex={dataIndex}
          record={record}
          type={props.type}
          onBlur={save}
          onClick={onClickEvent}
          disabled={props.disabled}
        />
      ) : (
        <Button type="text">{children[1]}</Button>
      )}
    </Form.Item>
  );
  return <td {...restProps}>{childNode}</td>;
};

const EditFormTable = forwardRef((props, ref) => {
  const { initData, defaultColumns, setTableData, mergeTable } = props;
  const customer = useContext(ServiceContext);
  const [dataSource, setDataSource] = useState([]);
  const [skuVisble, setSkuVisble] = useState(false);
  const [skuNameItem, setSkuNameItem] = useState({
    skuName: '',
    rowIndex: null,
  });
  const [form] = Form.useForm();
  useEffect(() => {
    console.log('==============>坚听initData', initData);
    form.setFieldsValue({
      tableList: initData,
    });
    setDataSource(initData);
  }, [initData]);

  const handleAdd = async () => {
    try {
      const { tableList } = await form.validateFields();
      console.log(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };

  const handleSave = row => {
    setTableData([...row]);
  };

  const onCheck = async () => {
    try {
      const values = await form.validateFields();
      return values;
    } catch (errorInfo) {
      return null;
    }
  };

  const rowOnClickEvent = row => {
    setSkuVisble(true);
    setSkuNameItem({
      skuName: row.name,
      rowIndex: row.rowIndex,
    });
  };

  const cancelEvent = () => {
    setSkuVisble(false);
  };

  const confirmEvent = skuItem => {
    const newDataSource = [...dataSource];
    newDataSource[skuItem.rowIndex].name = skuItem.skuName;
    setDataSource(newDataSource);
    form.setFieldsValue({
      tableList: newDataSource,
    });
  };

  useImperativeHandle(ref, () => ({
    onCheck,
    form,
  }));

  // 根据这里做判断渲染表格
  const columns = defaultColumns
    .filter(item => !item.role || item.role.includes(customer.productType))
    .map((col, colIndex) => ({
      ...col,
      onCell: (record, rowIndex) => {
        let rowSpan = null;
        if (col.dataIndex === 'firstSpecValue' && mergeTable) {
          rowSpan = record.rowSpanCount || 0;
        }

        return {
          rowSpan,
          record,
          rowIndex,
          roleRules: col.roleRules || {},
          editable: col.editable,
          dataIndex: col.dataIndex,
          disabled: col.disabled,
          type: col.inputType,
          roleProps: col.roleProps || {},
          title: col.title,
          handleSave,
          rowOnClickEvent,
        };
      },
    }));

  return (
    <div>
      <Form form={form} scrollToFirstError component={false}>
        <EditableContext.Provider value={form}>
          <Table
            pagination={false}
            size="small"
            components={{
              body: {
                row: EditableRow,
                cell: EditableCell,
              },
            }}
            bordered
            dataSource={dataSource}
            rowKey={row => UUID.createUUID()}
            columns={columns}
          />
        </EditableContext.Provider>
        <Button onClick={handleAdd} type="primary" style={{ marginBottom: 16 }}>
          Add a row
        </Button>
      </Form>
      <Button onClick={() => {}}></Button>
      <UpdateSkuName
        skuVisble={skuVisble}
        form={form}
        value={skuNameItem}
        confirmEvent={confirmEvent}
        cancelEvent={cancelEvent}
      />
    </div>
  );
});

export default EditFormTable;
