import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { goodsApi, kdspApi } = config;

export const merchantUpload = async files => {
  const params = new FormData();
  files.forEach(file => params.append('file', file));
  const data = await request.post('/image/api/merchant/upload', {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

export const getProductDetail = id =>
  request.post('/mock/389/product/detail', {
    prefix: 'http://yapi.quantgroups.com',
    data: { id },
  });

export const merchantCategoryGetAll = () =>
  request.post('/product/category/api/merchant/getAll', {
    prefix: goodsApi,
  });

// 获取商品品牌
export const merchantBrandList = () =>
  request.post('/product/brand/api/merchant/list', {
    prefix: goodsApi,
  });
