import { Form, Input, Select, Checkbox, DatePicker, Radio, InputNumber } from 'antd';
import React, { useState, useEffect, forwardRef, useImperativeHandle } from 'react';
import moment from 'moment';
import { useParams } from 'react-router-dom';
import UploadImage from './UploadImage';
import { WeeksList } from '../config';

const { Option } = Select;
const { RangePicker } = DatePicker;

const formItemLayout = {
  labelCol: {
    sm: { span: 3 },
  },
  wrapperCol: {
    sm: { span: 16 },
  },
};

const WeekCheckBox = () =>
  WeeksList.map(item => (
    <Checkbox key={item.value} value={item.value} style={{ lineHeight: '32px' }}>
      {item.name}
    </Checkbox>
  ));

const formatTime = (time, crm = 'YYYY-MM-DD HH') => time.format(crm);
const resetTime = (time, crm = 'YYYY-MM-DD HH') => moment(time, crm);

const rangeConfig = {
  rules: [{ type: 'array', required: true, message: 'Please select time!' }],
};

const FormRuleSetting = forwardRef((props: { editData: any }, ref) => {
  const [form] = Form.useForm();
  const { editData } = props;

  const url = 'https://zos.alipayobjects.com/rmsportal/jkjgkEfvpUPVyRjUImniVslZfWPnJuuZ.png';

  const { id } = useParams<any>();
  const [imageList, setImageList] = useState([]);
  const [commonImageList, setCommonImageList] = useState([]);
  const [detailImageList, setDetailImageList] = useState([]);
  useEffect(() => {
    console.log(id);
    if (+id !== 0) {
      console.log();
      if (!Object.keys(editData).length) return;
      setImageList(editData.commonImageList);
      setCommonImageList(editData.commonImageList);
      setDetailImageList(editData.detailImageList);
      const { serviceItem } = editData.skuList[0];
      form.setFieldsValue({
        useTime: [resetTime(serviceItem.useStartTime), resetTime(serviceItem.useEndTime)],
        purchaseTime: [
          resetTime(serviceItem.purchaseStartTime),
          resetTime(serviceItem.purchaseEndTime),
        ], // 购买开始时间
        shopIds: serviceItem.shopIds || [], // 适用门店列表
        unavailableDate: serviceItem.unavailableDate, // 不可用日期
        useTimeDescription: serviceItem.useTimeDescription, // 使用时间
        useMethod: serviceItem.useMethod, // 使用方法
        ruleDescription: serviceItem.ruleDescription, // 规则说明
        applyScope: serviceItem.applyScope, // 适用范围
        tips: serviceItem.tips, // 温馨提示

        imageList: editData.commonImageList,
        commonImageList: editData.commonImageList,
        detailImageList: editData.detailImageList,
        appointment: '0', // 预约
      });
    }
  }, [id, editData]);

  const onCheck = async () => {
    try {
      const { useTime, purchaseTime, ...values } = await form.validateFields();
      return {
        useStartTime: formatTime(useTime[0]),
        useEndTime: formatTime(useTime[1]),

        purchaseStartTime: formatTime(purchaseTime[0]),
        purchaseEndTime: formatTime(purchaseTime[1]),
        ...values,
      };
    } catch (errorInfo) {
      return null;
    }
  };

  useImperativeHandle(ref, () => ({
    onCheck,
  }));

  const onFinish = (values: any) => {
    console.log('Received values of form: ', values);
  };
  return (
    <>
      <Form
        {...formItemLayout}
        form={form}
        name="register"
        onFinish={onFinish}
        initialValues={{
          useTime: [], // 使用开始时间
          // useEndTime: '', // 使用结束时间
          purchaseTime: [], // 购买开始时间
          // purchaseEndTime: '2022-07-27 06', // 购买结束时间
          shopIds: [], // 适用门店列表
          unavailableDate: [], // 不可用日期
          useTimeDescription: '', // 使用时间
          useMethod: '', // 使用方法
          ruleDescription: '', // 规则说明
          applyScope: '', // 适用范围
          tips: '', // 温馨提示

          imageList,
          commonImageList,
          detailImageList,

          appointment: '', // 预约
        }}
        scrollToFirstError
      >
        <Form.Item name="useTime" label="购买时间" {...rangeConfig}>
          <RangePicker showTime format="YYYY-MM-DD HH" />
        </Form.Item>
        <Form.Item name="purchaseTime" label="有效期" {...rangeConfig}>
          <RangePicker showTime format="YYYY-MM-DD HH" />
        </Form.Item>
        <Form.Item
          name="shopIds"
          label="适用门店"
          rules={[{ required: true, message: '请选择适用门店!', type: 'array' }]}
        >
          <Select mode="multiple" placeholder="请选择适用门店">
            <Option value={1}>Male</Option>
            <Option value={2}>Female</Option>
            <Option value={3}>Other</Option>
          </Select>
        </Form.Item>

        <Form.Item
          name="unavailableDate"
          label="不可用日期"
          rules={[{ required: true, message: '请选择不可用日期!', type: 'array' }]}
        >
          <Checkbox.Group>{WeekCheckBox()}</Checkbox.Group>
        </Form.Item>
        <Form.Item
          name="useTimeDescription"
          label="使用时间"
          rules={[{ required: false, message: '请输入描述！' }]}
        >
          <Input.TextArea
            showCount
            maxLength={100}
            placeholder="例如：11:00-12:00;14:00-17:00可用，其他时间不可用"
          />
        </Form.Item>
        <Form.Item
          name="useMethod"
          label="使用方法"
          rules={[{ required: false, message: '请输使用方法，200字以内！' }]}
        >
          <Input.TextArea showCount maxLength={200} placeholder="请输使用方法，200字以内！" />
        </Form.Item>
        <Form.Item
          name="ruleDescription"
          label="规则说明"
          rules={[{ required: false, message: '请输规则说明，200字以内！' }]}
        >
          <Input.TextArea showCount maxLength={200} placeholder="请输规则说明，200字以内！" />
        </Form.Item>
        <Form.Item
          name="applyScope"
          label="适用范围"
          rules={[{ required: false, message: '请输入适用范围' }]}
        >
          <Input.TextArea
            showCount
            maxLength={50}
            placeholder="请输入适用范围，50字以内 例如：全场通用"
          />
        </Form.Item>
        <Form.Item
          name="tips"
          label="温馨提示"
          rules={[{ required: false, message: '请输入温馨提示' }]}
        >
          <Input.TextArea
            showCount
            maxLength={200}
            placeholder="请输入温馨提示，200字以内 例如：全场通用例如：\n不兑零"
          />
        </Form.Item>
        <Form.Item
          label="封面图片"
          name="commonImageList"
          extra={`建议尺寸: ##宽##高 (${commonImageList.length} / 1) `}
          rules={[
            { required: true, type: 'array', message: '请输入温馨提示', validateTrigger: 'submit' },
          ]}
        >
          <UploadImage
            name="commonImageList"
            limit={1}
            pictures={commonImageList}
            setPictureList={setCommonImageList}
          />
        </Form.Item>
        <Form.Item
          label="商品图片"
          name="imageList"
          extra={`建议尺寸: ##宽##高 (${imageList.length} / 11) `}
          rules={[
            { required: true, type: 'array', message: '请输入温馨提示', validateTrigger: 'submit' },
          ]}
        >
          <UploadImage
            name="imageList"
            limit={11}
            pictures={imageList}
            setPictureList={setImageList}
          />
        </Form.Item>
        <Form.Item
          label="商品详情图"
          name="detailImageList"
          extra={`最多上传30张，${detailImageList.length} / 30`}
          rules={[
            { required: true, type: 'array', message: '请输入温馨提示', validateTrigger: 'submit' },
          ]}
        >
          <UploadImage
            name="detailImageList"
            limit={4}
            pictures={detailImageList}
            setPictureList={setDetailImageList}
          />
        </Form.Item>

        <Form.Item name="appointment" label="预约">
          <Radio.Group>
            <Radio value="1">是</Radio>
            <Radio value="0">否</Radio>
          </Radio.Group>
        </Form.Item>
        <Form.Item
          name="meiri"
          label="每日最低接待量"
          rules={[{ required: true, message: '每日最低接待量' }]}
        >
          <InputNumber min={0} style={{ width: 200 }} placeholder="请输入每日最低接待量" />
        </Form.Item>
      </Form>
    </>
  );
});

export default FormRuleSetting;
