import React from 'react';
import { TaskList } from '../config';
import { Task } from '../type';
import commonStyle from '../common.less';

export const TaskTypeSelect = (props: { productType: number; onChange: (task: Task) => void }) => (
  <div className={commonStyle.prodcutContent}>
    {TaskList.map((task: Task) => {
      const activeClassName: string = props.productType === task.type ? commonStyle.activeCard : '';
      return (
        <dl
          key={task.type}
          onClick={() => props.onChange(task)}
          className={`${commonStyle.productCard} ${activeClassName}`}
        >
          <dd className="prodcut-name">{task.name}</dd>
          <dd className="prodcut-desc">({task.desc})</dd>
        </dl>
      );
    })}
  </div>
);
