import { stringify } from 'querystring';
import request from '@/utils/request';
import _ from 'lodash';
import config from '../../../config/env.config';

const { goodsApi } = config;

// 分页查询所有数据
export async function query(params) {
  const param = {
    ...params,
    pageIndex: params.current,
    pageSize: params.pageSize || 20,
  };
  const data = await request.post('/api/merchants/suppliers/contract/list', {
    prefix: goodsApi,
    data: param,
    headers: {
      'Content-Type': 'application/json;charset=UTF-8',
    },
  });
  if (data.data) {
    return {
      data: data.data,
    };
  }
  return {
    total: 0,
    data: [],
  };
}
