import React from 'react';
import { Image as ImageComponent, Button } from 'antd';
import { FormOutlined } from '@ant-design/icons';

export const repastTypeList = [
  {
    value: 1,
    label: '外卖',
  },
  {
    value: 2,
    label: '自助餐',
  },
  {
    value: 4,
    label: '到店',
  },
];

const repastType = list => {
  if (list.includes(4) && list.length > 1) {
    return list
      .filter(item => item !== 4)
      .map(item => {
        const name = repastTypeList.find(i => i.value === item)?.label;
        return name ? `${name}/到店 ` : null;
      });
  }
  return list.map(item => {
    const name = repastTypeList.find(i => i.value === item)?.label;
    return name ? `${name} ` : null;
  });
};
export const columns = props => [
  {
    title: '微店ID',
    key: 'shopId',
    dataIndex: 'shopId',
    align: 'center',
  },
  {
    title: '微店名称',
    key: 'shopName',
    dataIndex: 'shopName',
    align: 'center',
  },
  {
    title: '餐品类型',
    key: 'mealType',
    dataIndex: 'mealType',
    align: 'center',
    render: (_, row) => {
      const status = !row?.pickNameList?.length;
      const isArray = Array.isArray(row?.mealType);
      if (isArray) {
        return (
          <Button type="text" disabled={status} onClick={() => props.editRepastType(row)}>
            {repastType(row?.mealType)}
            <FormOutlined />
          </Button>
        );
      }
      return '/';
    },
  },
  {
    title: '所属企业取餐点',
    key: 'pickNameList',
    dataIndex: 'pickNameList',
    align: 'center',
    render: (text, record) => {
      if (record.pickNameList?.length) {
        return text.map((item, index) => (
          <span key={item}>
            {item}
            {index < record.pickNameList.length - 1 && ','}
          </span>
        ));
      }
      return '/';
    },
  },
  {
    title: '修改人',
    key: 'updatedBy',
    dataIndex: 'updatedBy',
    align: 'center',
  },
  {
    title: '修改时间',
    key: 'updatedAt',
    dataIndex: 'updatedAt',
    align: 'center',
  },
  {
    title: '操作',
    dataIndex: 'option',
    valueType: 'option',
    align: 'center',
    key: 'option',
    render: (_, row) => (
      <Button type="link" disabled={row?.pickNameList?.length} onClick={() => props.delShop(row)}>
        删除
      </Button>
    ),
  },
];
