import React, { useState, useEffect, forwardRef, useRef, useImperativeHandle } from 'react';
import { Button, Modal, Form, Checkbox, Row, Col, time, DatePicker } from 'antd';
import { map } from 'lodash';
import { MinusCircleOutlined, PlusOutlined } from '@ant-design/icons';
import moment from 'moment';
import { ENUM_WEEK } from '../config';
import styles from '../common.less';

const format = 'HH:mm';
const { RangePicker } = DatePicker;
const AddSellTimeModal = (props, ref) => {
  const [confirmLoading, setConfirmLoading] = useState(false);
  const [modalText, setModalText] = useState('Content of the modal');
  const [formProject] = Form.useForm();
  const [open, setOpen] = useState(false);

  const { saleDates, setSaleDates } = props;
  useImperativeHandle(ref, () => ({
    // changeVal 就是暴露给父组件的方法
    setOpen: newVal => {
      setOpen(newVal);
    },
  }));
  const handleOk = () => {
    formProject.validateFields().then(async values => {
      console.log('valuse', values);
      setConfirmLoading(true);
      setSaleDates(values);
      setTimeout(() => {
        setOpen(false);
        setConfirmLoading(false);
      }, 1000);
    });
  };

  const handleCancel = () => {
    console.log('Clicked cancel button');
    setOpen(false);
  };
  useEffect(() => {
    console.log('open', open);
    // formProject.setFieldsValue({ saleTimes: [['12:00', '13:00']] })
  }, [open]);
  const onChange = () => {};
  return (
    <>
      {open && (
        <Modal
          title="售卖时段"
          visible={open}
          onOk={handleOk}
          confirmLoading={confirmLoading}
          onCancel={handleCancel}
          width={1050}
        >
          <Form
            name="sellTime"
            form={formProject}
            // {...formItemLayout}
            // onFinish={onFinish}
            initialValues={saleDates}
          >
            <Form.Item name="unavailableDate" label="售卖时期(可多选)">
              <Checkbox.Group>
                <Row>
                  <Col className={styles.colRow} span={8}>
                    {ENUM_WEEK.map((item, index) => (
                      <Checkbox value={item.value}>{item.label}</Checkbox>
                    ))}
                  </Col>
                </Row>
              </Checkbox.Group>
            </Form.Item>

            <Form.Item label="售卖时段">
              <Form.List
                name="saleTimes"
                initialValue={[[]]}
                // rules={[
                //   {
                //     validator: async (_, times) => {
                //       if (!times || times.length < 2) {
                //         return Promise.reject(new Error('At least 2 passengers'));
                //       }
                //     },
                //   },
                // ]}
              >
                {(fields, { add, remove }) => (
                  <>
                    {fields.map((field, index) => (
                      <Form.Item
                        // {...(index === 0 ? formItemLayout : formItemLayoutWithOutLabel)}
                        required={false}
                        key={field.key}
                        className={styles.deal}
                      >
                        <Form.Item
                          className={styles.deal}
                          {...field}
                          // validateTrigger={['onChange', 'onBlur']}
                          rules={[
                            {
                              required: true,
                              message: '请输入售卖时间',
                            },
                          ]}
                        >
                          <RangePicker picker="time" format={format} onChange={onChange} />
                        </Form.Item>
                        {fields.length > 1 ? (
                          <MinusCircleOutlined
                            className="dynamic-delete-button"
                            onClick={() => remove(field.name)}
                          />
                        ) : null}
                      </Form.Item>
                    ))}
                    <Form.Item>
                      <Button
                        type="dashed"
                        onClick={() => add()}
                        style={{ width: '60%' }}
                        icon={<PlusOutlined />}
                      >
                        新增时段
                      </Button>
                    </Form.Item>
                  </>
                )}
              </Form.List>
            </Form.Item>
          </Form>
        </Modal>
      )}
    </>
  );
};

export default forwardRef(AddSellTimeModal);
