import React from 'react';
import { Image as ImageComponent, Button } from 'antd';

export const getLastItem = thePath => thePath.substring(thePath.lastIndexOf('/') + 1);
export const isImageType = url => {
  const index = url.lastIndexOf('.');
  const ext = url.substr(index + 1);
  return ['png', 'jpg', 'jpeg', 'bmp', 'gif', 'webp', 'psd', 'svg', 'tiff'].includes(
    ext.toLowerCase(),
  );
};

export const checkImage = url =>
  new Promise(resolve => {
    const image = new Image();
    image.onload = () => {
      resolve(true);
    };
    image.onerror = () => {
      resolve(false);
    };
    image.src = url;
  });

const csListStyle = {
  color: '#1890FF',
  textAlign: 'left',
  whiteSpace: 'nowrap',
  textOverflow: 'ellipsis',
  overflow: 'hidden',
  cursor: 'pointer',
};

export const typeConfig = {
  1: {
    text: '退运费',
  },
  2: {
    text: '商品破损',
  },
};

const singleNumberSearch = {
  0: {
    text: '赔款单号',
  },
  1: {
    text: '订单编号',
  },
};

export const columnsConfig = props => [
  {
    title: '单号搜索',
    key: 'singleType',
    dataIndex: 'singleType',
    hideInTable: true,
    valueEnum: singleNumberSearch,
  },
  {
    key: 'singleNumber',
    dataIndex: 'singleNumber',
    hideInTable: true,
  },
  {
    title: '赔款单号',
    key: 'id',
    dataIndex: 'id',
    align: 'center',
    hideInSearch: true,
  },
  {
    title: '订单号',
    key: 'orderNo',
    dataIndex: 'orderNo',
    align: 'center',
    hideInSearch: true,
  },
  {
    title: '赔款金额',
    key: 'amount',
    dataIndex: 'amount',
    align: 'center',
    width: 100,
    hideInSearch: true,
  },
  {
    title: '赔款类型',
    key: 'type',
    dataIndex: 'type',
    align: 'center',
    valueEnum: typeConfig,
  },
  {
    title: '索赔原因',
    key: 'reason',
    dataIndex: 'reason',
    align: 'center',
    hideInSearch: true,
  },
  {
    title: '退款说明',
    key: 'remark',
    dataIndex: 'remark',
    align: 'center',
    ellipsis: true,
    hideInSearch: true,
  },
  {
    title: '创建时间',
    key: 'createdAt',
    dataIndex: 'createdAt',
    align: 'center',
    valueType: 'dateRange',
  },
  {
    title: '用户凭证',
    key: 'proof',
    dataIndex: 'proof',
    align: 'center',
    width: 190,
    hideInSearch: true,
    render: value =>
      (value.userList || []).map(item => (
        <ImageComponent style={{ paddingLeft: 5, marginTop: 5 }} key={item} width={50} src={item} />
      )),
  },
  {
    title: '审核意见',
    key: 'proof',
    dataIndex: 'proof',
    align: 'center',
    width: 190,
    hideInSearch: true,
    render: value =>
      (value.csList || []).map(item => (
        <div style={csListStyle} onClick={() => props.downLoadFile(item)}>
          {item}
        </div>
      )),
  },
];
