import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { kdspApi } = config;

// 分页查询所有数据
export async function searchList(params, queryStatus) {
  const param = {
    ...params,
    pageNo: params.current,
    pageSize: params.pageSize || 20,
    queryStatus,
  };
  const data = await request.post('/api/kdsp/op/afs/shop/list', {
    prefix: kdspApi,
    data: stringify(_.omitBy(param, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  if (data.data) {
    return {
      total: data.data.total,
      data: data.data.records,
    };
  }
  return {
    total: 0,
    data: [],
  };
}

// 售后单详情
export async function orderDetail(params) {
  const data = await request.get('/api/kdsp/op/afs/sku', {
    prefix: kdspApi,
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data.data || [];
}
// 售后审核
export async function shopAudit(params) {
  return request.post('/api/kdsp/op/afs/shop/audit', {
    data: stringify(params),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    prefix: kdspApi,
  });
}
// 查询审核信息
export async function auditInfoApi(params) {
  return request.get('/api/kdsp/op/afs/back-info', {
    params,
    prefix: kdspApi,
  });
}

// 审核核检
export async function shopCheck(params) {
  return request.post('/api/kdsp/op/afs/shop/check', {
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    prefix: kdspApi,
  });
}
// 查询物流信息
export async function trackInfo(params) {
  const data = await request.get('/api/kdsp/op/logistics/kd100/track-list', {
    params,
    prefix: kdspApi,
  });
  if (data.businessCode === '0000') {
    return data.data;
  }
  return {};
}
