import React from 'react';
import { Modal, Form, Input, notification } from 'antd';
import { shopCheck } from '../services';

const FormItem = Form.Item;
const { TextArea } = Input;
const RejectModal = props => {
  const {
    visible,
    onCancel,
    form: { getFieldDecorator, validateFields, resetFields },
    serviceNo = null,
  } = props;

  const handleCancel = isSuccess => {
    resetFields();
    onCancel(isSuccess);
  };
  const handleOk = () => {
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        const data = await shopCheck({
          ...fieldsValue,
          serviceNo,
          auditResult: 2,
        });
        if (data.code === '0000') {
          notification.success({ message: '操作成功' });
          handleCancel(true);
        }
      }
    });
  };

  const layout = {
    labelCol: { span: 6 },
    wrapperCol: { span: 16 },
  };
  return (
    <Modal title="驳回" visible={visible} onOk={() => handleOk()} onCancel={() => handleCancel()}>
      <Form {...layout} name="formData">
        <FormItem label="原因">
          {getFieldDecorator('refuseDesc', {
            rules: [
              {
                required: true,
                message: '请填写原因!',
              },
            ],
          })(
            <TextArea placeholder="请填写原因" allowClear autoSize={{ minRows: 3, maxRows: 6 }} />,
          )}
        </FormItem>
      </Form>
    </Modal>
  );
};

export default Form.create()(RejectModal);
