import { Upload, Icon, Modal } from 'antd';
import React from 'react';
import { ReactSortable } from 'react-sortablejs';
import { uploadImg } from '../../GoodsManage/service';
import styles from './styles.less';

class PicturesWall extends React.Component {
  state = {
    previewVisible: false,
    previewImage: '',
    fileList: [],
    newFile: [],
    activeImgIndex: null,
  };

  async componentDidMount() {
    this.initFileList(this.props.fileList || []);
  }

  componentWillReceiveProps(nextProps) {
    this.initFileList(nextProps.fileList || []);
  }

  initFileList = fileList => {
    const fileLists =
      fileList.map((item, index) => ({
        url: item,
        name: index,
        uid: index,
        status: 'done',
      })) || [];
    this.setState({ fileList: fileLists });
  };

  handleCancel = () => this.setState({ previewVisible: false });

  handlePreview = async img => {
    this.setState({
      previewImage: img.url,
      previewVisible: true,
    });
  };

  clearFileList = () => {
    this.setState({
      fileList: [],
    });
  };

  sortChange = list => {
    this.setState({ fileList: list });
    const urlList = list.map(item => item.url);
    this.props.onChange(urlList);
  };

  onRemoveImg = file => {
    this.setState(
      state => {
        const index = state.fileList.indexOf(file);
        const newFileList = state.fileList.slice();
        newFileList.splice(index, 1);
        return {
          fileList: newFileList,
        };
      },
      () => {
        const urlList = this.state.fileList.map(item => item.url);
        this.props.onChange(urlList);
      },
    );
  };

  render() {
    // TODO 图片限制大小
    const { previewVisible, previewImage, fileList } = this.state;
    const uploadButton = (
      <div>
        <Icon type="plus" />
        <div className="ant-upload-text">上传图片</div>
      </div>
    );
    const { max } = this.props;
    const that = this;
    const uploadProps = {
      beforeUpload: file => {
        console.log(file);
        this.setState(
          state => ({
            newFile: [...state.newFile, file],
          }),
          async () => {
            const data = await uploadImg(that.state.newFile);
            this.setState({ newFile: [] });
            if (!data || !data.data) return;
            const { length } = this.state.fileList;
            const list = data.data.map((img, index) => ({
              url: img,
              uid: index + length,
              name: index + length,
              status: 'done',
            }));
            this.setState(
              state => ({ fileList: [...state.fileList, ...list] }),
              () => {
                const urlList = this.state.fileList.map(item => item.url);
                this.props.onChange(urlList);
              },
            );
          },
        );
        return false;
      },
      listType: 'picture-card',
    };
    return (
      <div className="clearfix">
        <div className={styles.imgContent}>
          {fileList.length > 0 && (
            <ReactSortable list={fileList} setList={list => this.sortChange(list)}>
              {fileList.map((item, index) => (
                <div
                  // eslint-disable-next-line react/no-array-index-key
                  key={index}
                  className={styles.sortImg}
                  onMouseEnter={() => this.setState({ activeImgIndex: index })}
                  onMouseLeave={() => this.setState({ activeImgIndex: null })}
                >
                  <div style={{ width: '100%', height: '100%', overflow: 'hidden' }}>
                    <img width="100%" key={item.uid} src={item.url} alt="" />
                  </div>
                  {this.state.activeImgIndex === index && (
                    <div className={styles.mask}>
                      <Icon
                        type="eye"
                        className={styles.maskIcon}
                        onClick={() => this.handlePreview(item)}
                      />
                      <Icon
                        type="delete"
                        className={styles.maskIcon}
                        onClick={() => this.onRemoveImg(item)}
                      />
                    </div>
                  )}
                </div>
              ))}
            </ReactSortable>
          )}
        </div>
        <Upload multiple {...uploadProps} fileList={fileList} showUploadList={false}>
          {max && fileList.length >= max ? null : uploadButton}
        </Upload>
        <Modal visible={previewVisible} footer={null} onCancel={this.handleCancel}>
          <img alt="example" style={{ width: '100%' }} src={previewImage} />
        </Modal>
      </div>
    );
  }
}
export default PicturesWall;
