import React, { useState, useEffect, useRef } from 'react';
import { useHistory } from 'react-router-dom';
import { ProTable } from '@ant-design/pro-components';
import { Button, Space } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { takeawayGoodsColumn } from './staticData/goods';
import utilStyle from '@/utils/utils.less';
import { apiTakeawayList } from './service';
import { getEnterpriseList } from './service/bll';
import SaleDateModal from './components/SaleDateModal';
import SaleSectionModal from './components/SaleSectionModal';
import GoodPriceModal from './components/GoodPriceModal';
import GoodSortModal from './components/GoodSortModal';
import { getToUrlQuery } from '@/utils/utils';

const BusinessCustomer = () => {
  const history = useHistory();
  const refTable = useRef();
  const [pageLoading, setPageLoading] = useState(false); // 可售日期弹窗
  const [visibleSaleDate, setVisibleSaleDate] = useState(false); // 可售日期弹窗
  const [visibleSaleSection, setVisibleSaleSection] = useState(false); // 可售餐段弹窗
  const [visiblePrice, setVisiblePrice] = useState(false); // 修改企业商品价格弹窗
  const [visibleSort, setVisibleSort] = useState(false); // 商品排序弹窗
  const [enterprises, setEnterprises] = useState([]); // 企业列表
  const [activeKey, setActiveKey] = useState('tab1');
  const [enterpriseId, setEnterpriseId] = useState('10');
  const searchList = async params => {
    const data = {
      page: params.current,
      size: params.pageSize,
      data: params,
    };
    return apiTakeawayList(data);
  };
  const onDel = async () => {};
  const onAdd = async () => {
    const query = getToUrlQuery();
    history.push({
      pathname: '/takeawayGoodsInfo',
      query,
    });
  };
  const options = {
    setVisibleSaleDate,
    setVisibleSaleSection,
    setVisiblePrice,
    setVisibleSort,
    onDel,
    enterprises,
  };

  // 获取企业列表
  const getList = async name => {
    const obj = getEnterpriseList(name);
    setEnterprises(obj.list);
    setEnterpriseId(obj.id);
    setPageLoading(true);
  };

  useEffect(() => {
    getList('');
    // setTimeout(() => {
    //   // refTable.current.reload();
    // }, 1000);
  }, []);

  return (
    <div>
      {pageLoading && (
        <ProTable
          search={{
            span: 6,
            className: utilStyle.formSearch,
            collapsed: false,
            collapseRender: () => null,
          }}
          actionRef={refTable}
          tableClassName={utilStyle.formTable}
          columns={takeawayGoodsColumn(options)}
          request={params => searchList({ ...params })}
          rowKey={r => r.id}
          expandIconColumnIndex={10}
          bordered
          options={false}
          form={{ initialValues: { enterpriseId } }}
          toolbar={{
            menu: {
              type: 'tab',
              activeKey,
              items: [
                {
                  key: 'tab1',
                  label: <span>取餐点1</span>,
                },
                {
                  key: 'tab2',
                  label: <span>取餐点2</span>,
                },
                {
                  key: 'tab3',
                  label: <span>取餐点3</span>,
                },
              ],
              onChange: key => {
                setActiveKey(key);
              },
            },
            actions: [
              <Button key="1" icon={<PlusOutlined />} type="primary" onClick={onAdd}>
                添加外卖商品
              </Button>,
            ],
          }}
          scroll={{ x: '100%', y: 400 }}
        />
      )}
      {/* 可售日期弹窗 */}
      {visibleSaleDate && (
        <SaleDateModal visible={visibleSaleDate} handleClose={() => setVisibleSaleDate(false)} />
      )}
      {/* 可售餐段弹窗 */}
      {visibleSaleSection && (
        <SaleSectionModal
          visible={visibleSaleSection}
          handleClose={() => setVisibleSaleSection(false)}
        />
      )}
      {/* 修改企业商品价格弹窗 */}
      {visiblePrice && (
        <GoodPriceModal visible={visiblePrice} handleClose={() => setVisiblePrice(false)} />
      )}
      {/* 商品排序弹窗 */}
      {visibleSort && (
        <GoodSortModal visible={visibleSort} handleClose={() => setVisibleSort(false)} />
      )}
    </div>
  );
};

export default BusinessCustomer;
