import React from 'react';
import { Button, Space, Switch } from 'antd';
import { FormOutlined } from '@ant-design/icons';
import { jsonToArray } from '@/utils/utils';

export const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 18 },
};
// 0-推荐 1-早餐 2-午餐 3-下午茶 4-晚餐
export const mealColumn = {
  // 0: '推荐',
  1: '早餐',
  2: '午餐',
  // 3: '晚餐',
  4: '晚餐',
};

export const weekOptions = {
  1: '周一',
  2: '周二',
  3: '周三',
  4: '周四',
  5: '周五',
  6: '周六',
  7: '周日',
};

export const takeawayGoodsColumn = options => {
  const { onDel, companyEnum, shopEnum, onChangeFlag, setVisibleSaleDate, enterprises } = options;
  return [
    {
      title: '企业名称',
      dataIndex: 'enterpriseId',
      hideInTable: true,
      valueEnum: enterprises, // companyEnum,
    },
    {
      title: '微店名称',
      dataIndex: 'shopId',
      hideInTable: true,
      valueEnum: {}, // shopEnum,
    },
    {
      title: 'SKU编码',
      dataIndex: 'skuId',
      width: 120,
      align: 'center',
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      width: 120,
      align: 'center',
    },
    {
      title: '商品图片',
      dataIndex: 'primaryImage',
      width: 120,
      align: 'center',
      hideInSearch: true,
      valueType: 'image',
    },
    {
      title: '可售日期',
      dataIndex: 'saleTimeType',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span onClick={setVisibleSaleDate(true)}>
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '可售餐段',
      dataIndex: 'saleDate',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span>
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '企业价格',
      dataIndex: 'activityPrice',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span>
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '商品销售价',
      dataIndex: 'price',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '状态',
      dataIndex: 'status',
      width: 120,
      align: 'center',
      hideInSearch: true,
      valueEnum: {
        1: '生效中',
        2: '已下架',
        3: '已售罄',
      },
    },
    {
      title: '排序',
      dataIndex: 'sort',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span>
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '列出商品',
      dataIndex: 'showFlag',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>
            <Switch onChange={onChangeFlag} />
          </span>
        </Space>
      ),
    },
    {
      title: '餐品类型',
      dataIndex: 'mealType',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '添加时间',
      dataIndex: 'createDate',
      width: 120,
      valueType: 'dateRange',
      align: 'center',
    },
    {
      title: '当日餐段',
      dataIndex: 'tabId',
      width: 120,
      align: 'center',
      valueEnum: mealColumn,
      hideInTable: true,
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: '100px',
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="del" onClick={() => onDel(r, 'del')}>
          删除
        </Button>
      ),
    },
  ];
};

export const GoodsInfoColumn = options => {
  const { onDel, companyEnum, shopEnum, onChangeFlag, setVisibleSaleDate } = options;
  return [
    {
      title: '微店名称',
      dataIndex: 'shopId',
    },
    {
      title: '商品名称',
      dataIndex: 'skuName',
      width: 120,
      align: 'center',
    },
    {
      title: '商品售价',
      dataIndex: 'price',
      width: 120,
      align: 'center',
    },
    {
      title: '企业价格',
      dataIndex: 'activityPrice',
      width: 120,
      align: 'center',
    },
    {
      title: '库存',
      dataIndex: 'status',
      width: 120,
      align: 'center',
    },
    {
      title: '可售日期',
      dataIndex: 'saleTimeType',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span onClick={setVisibleSaleDate(true)}>
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '可售餐段',
      dataIndex: 'saleDate',
      width: 120,
      align: 'center',
      hideInSearch: true,
      render: (_, record) => (
        <Space>
          <span>{_}</span>
          <span>
            <FormOutlined />
          </span>
        </Space>
      ),
    },
    {
      title: '餐品类型',
      dataIndex: 'mealType',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: '100px',
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="del" onClick={() => onDel(r, 'del')}>
          删除
        </Button>
      ),
    },
  ];
};

export const SelectGoodsColumn = [
  {
    title: '商品ID',
    width: 120,
    dataIndex: 'id',
  },
  {
    title: '商品名称',
    dataIndex: 'skuName',
    width: 120,
    align: 'center',
  },
  {
    title: '商品编号',
    dataIndex: 'skuNo',
    width: 120,
    align: 'center',
  },
  {
    title: '销售价',
    dataIndex: 'price',
    width: 120,
    align: 'center',
  },
  {
    title: '剩余库存',
    dataIndex: 'status',
    width: 120,
    align: 'center',
  },
  {
    title: '已参与活动',
    dataIndex: 'mealType',
    align: 'center',
    hideInSearch: true,
  },
];
