import request from '@/utils/request';
import config from '@/../config/env.config';

const { kdspApi, goodsApi } = config;

/**
 * 获取企业外卖商品列表
 * http://yapi.quantgroups.com/project/389/interface/api/64794
 */
export async function apiTakeawayList(param) {
  return request.post('/api/consoles/product/enterprise/main/pageList', {
    data: param,
    prefix: goodsApi,
  });
}
/**
 * 模糊查询店铺列表
 * http://yapi.quantgroups.com/project/389/interface/api/65289
 */
export async function apiEnterpriseList(param) {
  return request.post('/api/consoles/shops/getListByName', {
    data: param,
    prefix: goodsApi,
  });
}
/**
 * 企业团餐-查询餐段配置
 * http://yapi.quantgroups.com/project/389/interface/api/65444
 */
export async function apiMealTimePeriod(param) {
  return request.post('/api/consoles/product/enterprise/getMealTimePeriod', {
    data: param,
    prefix: goodsApi,
  });
}
/**
 * 企业团餐->信息修改
 * http://yapi.quantgroups.com/project/389/interface/api/65099
 */
export async function apiMealInfoUpdate(param) {
  return request.post('/api/consoles/product/enterprise/main/update', {
    data: param,
    prefix: goodsApi,
  });
}
/**
 * 企业团餐->删除
 * http://yapi.quantgroups.com/project/389/interface/api/65109
 */
export async function apiMealInfoDel(param) {
  return request.post('/api/consoles/product/enterprise/main/deleteById', {
    data: param,
    prefix: goodsApi,
  });
}
/**
 * 企业团餐->根据企业ID查询已选择自提点
 * http://yapi.quantgroups.com/project/389/interface/api/65449
 */
export async function apiSelPickSelfList(param) {
  return request.post('/api/consoles/product/enterprise/queryByEnterpriseId', {
    data: param,
    prefix: goodsApi,
  });
}
/**
 * 企业团餐->查询商品 - 选择商品弹窗
 * http://yapi.quantgroups.com/project/389/interface/api/65479
 */
export async function apiSelGoodsList(param) {
  return request.post('/api/consoles/product/enterprise/sku/page', {
    data: param,
    prefix: goodsApi,
  });
}
/**
 * 企业团餐->添加商品保存
 * http://yapi.quantgroups.com/project/389/interface/api/65094
 */
export async function apiSaveGoodsList(param) {
  return request.post('/api/consoles/product/enterprise/add', {
    data: param,
    prefix: goodsApi,
  });
}
