import React, { useState } from 'react';
import { Form, Select, Modal, Table, Input, Button, Pagination } from 'antd';
import { SearchOutlined } from '@ant-design/icons';
import { apiTakeawayList } from '../service';
import { SelectGoodsColumn } from '../staticData/goods';
import style from '../style/index.less';

const { Option } = Select;
const SaleDateModal = props => {
  const [form] = Form.useForm();
  const [searchType, setSearchType] = useState('1');
  const [loading, setLoading] = useState(false);
  const [page, setPage] = useState(1);
  const [pageSize, setPageSize] = useState(10);
  const [dataSource, setDataSource] = useState([]);
  const [selectedRowKeys, setSelectedRowKeys] = useState([]);

  const searchList = async params => {
    console.log('params :>> ', params);
    console.log('searchType :>> ', searchType);
    // const data = {
    //   page: params.current,
    //   size: params.pageSize,
    //   data: params,
    // };
    // return apiTakeawayList(data);
  };

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  // 提交
  const handleConfirm = async () => {
    const res = await form.validateFields();
    console.log('res :>> ', res);
  };

  const onSelectChange = newSelectedRowKeys => {
    console.log('selectedRowKeys changed: ', newSelectedRowKeys);
    setSelectedRowKeys(newSelectedRowKeys);
  };

  const onPageChange = (current, size) => {
    setPage(current);
    setPageSize(size);
  };

  const rowSelection = {
    selectedRowKeys,
    onChange: onSelectChange,
  };
  const selectBefore = (
    <Select defaultValue="1" onChange={setSearchType}>
      <Option value="1">名称</Option>
      <Option value="2">SKU</Option>
    </Select>
  );
  const selectAfter = <SearchOutlined onClick={searchList} />;
  const footers = () => [
    <div className={style.footers}>
      <Pagination defaultCurrent={6} total={500} showQuickJumper onChange={onPageChange} />
      <div className={style['footers-btn']}>
        <div className={style['footers-desc']}>
          已选商品(<span className={style['footers-num']}>0</span>)
        </div>
        <Button key="back" onClick={handleCancel}>
          取消
        </Button>
        <Button key="submit" type="primary" loading={loading} onClick={handleConfirm}>
          确定
        </Button>
      </div>
    </div>,
  ];

  return (
    <Modal
      title="选择商品"
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="1000px"
      onOk={handleConfirm}
      onCancel={handleCancel}
      footer={footers()}
    >
      <div className={style['select-goods-box']}>
        <Select placeholder="请选择店铺" className={style['select-goods-box--select']} />
        <Select
          placeholder="请选择商品类型"
          disabled
          className={style['select-goods-box--select']}
        />
        <Input
          addonBefore={selectBefore}
          addonAfter={selectAfter}
          className={style['select-goods-box--txt']}
        />
      </div>
      <Table rowSelection={rowSelection} columns={SelectGoodsColumn} dataSource={dataSource} />
    </Modal>
  );
};
export default SaleDateModal;
