import React from 'react';
import { Form, Space, Checkbox, TimePicker } from 'antd';
import { mealSections } from '../staticData/index';

const MealSection = props =>
  mealSections.map(field => (
    <Space key={field.key} align="baseline">
      <Form.Item label="">
        <Checkbox onChange={props.onChange} value={field.value} label={field.label}>
          {field.label}
        </Checkbox>
      </Form.Item>
      <Form.Item name={[field.time, field.key]}>
        <TimePicker.RangePicker format="HH:mm" />
      </Form.Item>
    </Space>
  ));

export default MealSection;
