import React, { useState } from 'react';
import { Form, Input, Checkbox, Space, Col, Row, Modal } from 'antd';
import { ExclamationCircleOutlined } from '@ant-design/icons';
import { jsonToArray } from '@/utils/utils';
import { mealColumn } from '../staticData/goods';

const SaleDateModal = props => {
  const [form] = Form.useForm();
  const [value, setValue] = useState([]);

  // 关闭弹窗
  const handleCancel = () => {
    props.handleClose(false);
  };

  const onChangeMeal = e => {
    setValue(e);
  };

  // 提交
  const handleConfirm = async () => {
    const res = await form.validateFields();
    console.log('res :>> ', res);
  };

  return (
    <Modal
      title={props.title || '修改可售餐段'}
      open={props.visible}
      destroyOnClose
      maskClosable={false}
      width="200px"
      onOk={handleConfirm}
      onCancel={handleCancel}
    >
      <Checkbox.Group onChange={onChangeMeal} value={value}>
        <Space direction="vertical">
          {Object.keys(mealColumn).map(key => (
            <Checkbox value={key}>{mealColumn[key]}</Checkbox>
          ))}
        </Space>
      </Checkbox.Group>
    </Modal>
  );
};
export default SaleDateModal;
