import React from 'react';
import { Button } from 'antd';

export const layout = {
  labelCol: { span: 4 },
  wrapperCol: { span: 18 },
};

export const customerColumn = options => {
  const { onEdit } = options;
  return [
    {
      title: 'ID',
      dataIndex: 'id',
      width: 120,
      align: 'center',
    },
    {
      title: '公司名称',
      dataIndex: 'name',
      width: 120,
      align: 'center',
    },
    {
      title: '截单时间(分钟)',
      dataIndex: 'times',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '餐品类型',
      dataIndex: 'types',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '创建人',
      dataIndex: 'cr',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '创建时间',
      dataIndex: 'createdAt',
      width: 120,
      align: 'center',
      hideInSearch: true,
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: 200,
      align: 'center',
      fixed: 'right',
      render: (val, r) => (
        <Button key="edit" onClick={() => onEdit(r, 'edit')}>
          编辑
        </Button>
      ),
    },
  ];
};

// export const typeOptions = [
//   { label: '外卖', value: 1 },
//   { label: '自助餐', value: 2 },
//   { label: '到店', value: 3 },
// ];
export const typeOptions = {
  1: '外卖',
  2: '自助餐',
  4: '到店',
};

export const infoOptions = [
  { label: '商品价格及图片', value: 1 },
  { label: '仅商品价格', value: 2 },
  { label: '仅商品图片', value: 3 },
  { label: '均不展示', value: 4 },
];

export const boolOptions = [{ label: '是', value: 1 }, { label: '否', value: 0 }];

export const mealSections = [
  {
    label: '早餐',
    value: '1',
    key: 'time1',
  },
  {
    label: '中餐',
    value: '2',
    key: 'time2',
  },
  {
    label: '晚餐',
    value: '3',
    key: 'time3',
  },
];
