import { Modal, Timeline } from 'antd';
import React, { Component } from 'react';

class RecordModal extends Component {
  state = {};

  onCancel = () => {
    this.props.onCancel();
  };

  render() {
    const { visible, data } = this.props;
    return (
      <Modal
        title="查看记录"
        visible={visible}
        onCancel={() => this.onCancel()}
        footer={null}
        width="500px"
      >
        {data?.length
          ? data.map((item, index) => (
              // eslint-disable-next-line react/no-array-index-key
              <Timeline key={`${index}${item.title}`}>
                {item.detailList?.map((log, i) => (
                  // eslint-disable-next-line react/no-array-index-key
                  <Timeline.Item color={i > 0 ? 'gray' : 'blue'} key={i}>
                    <p>{log.desc}</p>
                    <p>{log.logisticsTime}</p>
                  </Timeline.Item>
                ))}
              </Timeline>
            ))
          : '暂无记录'}
      </Modal>
    );
  }
}

export default RecordModal;
