import React, { useRef } from 'react';
import { useHistory } from 'react-router-dom';
import { Button, Divider } from 'antd';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';

// mock
import { logList } from '../mock/log';

const columns = [
  {
    title: '操作人',
    dataIndex: 'name',
  },
  {
    title: '一级菜单',
    dataIndex: 'menu',
  },
  {
    title: '二级菜单',
    dataIndex: 'subMenu',
  },
  {
    title: '操作点',
    dataIndex: 'status',
    hideInSearch: true,
  },
  {
    title: '操作时间',
    hideInSearch: true,
    dataIndex: 'actionTime',
  },
  {
    title: '操作时间2',
    hideInTable: true,
    dataIndex: 'actionTime1',
    valueType: 'dateRange',
  },
  {
    title: '操作',
    key: 'action',
    hideInSearch: true,
    render: () => (
      <>
        <a>查看</a>
      </>
    ),
  },
];

const SystemLog = props => {
  const history = useHistory();
  const actionRef = useRef();
  const formRef = useRef();

  const toUserInfo = (record = {}) => {
    const { id } = record;
    history.push({
      pathname: '/SystemManage/Account/UserInfo',
      query: {
        id: 1,
      },
    });
  };

  // 表格属性
  const tableProps = {
    columns,
    rowKey: 'id',
    request: params => {
      console.log('搜索', params);
      return new Promise(resolve => {
        setTimeout(() => {
          resolve({
            data: logList,
            success: true,
          });
        }, 2000);
      });
    },
    search: {
      collapsed: false,
      collapseRender: () => null,
    },
  };

  // 搜索属性
  const searchProps = {};
  return (
    <PageHeaderWrapper>
      <ProTable actionRef={actionRef} formRef={formRef} {...tableProps}></ProTable>
    </PageHeaderWrapper>
  );
};

export default SystemLog;
