import { Form } from '@ant-design/compatible';
import '@ant-design/compatible/assets/index.css';
import { Modal, notification, Input } from 'antd';
import React, { useState } from 'react';
import { apiDelayDeliverGoods } from '../service';

const UpdateStock = props => {
  const { getFieldDecorator, validateFields, resetFields } = props.form;
  const valueInfo = {};

  const [loading, setLoading] = useState(false);

  const submit = async () => {
    validateFields(async (err, { remark }) => {
      if (err) return;
      setLoading(true);
      const params = {
        orderIds: [props.orderId],
        operationType: 5,
        remark,
      };
      console.log('params :>> ', params);
      const res = await apiDelayDeliverGoods(params);
      if (res?.businessCode === '0000') {
        notification.success({ message: '提交成功！' });
        props.onCancel('success');
        resetFields();
      }
      setLoading(false);
    });
  };
  const onCancel = () => {
    props.onCancel();
    resetFields();
  };
  const formItemLayout = {
    labelCol: {
      span: 7,
    },
    wrapperCol: {
      span: 15,
    },
  };

  return (
    <Modal
      title="延迟发货"
      visible={props.visible}
      okButtonProps={{ loading }}
      onCancel={onCancel}
      onOk={submit}
      width={500}
    >
      <Form {...formItemLayout}>
        <Form.Item label="延迟原因:">
          {getFieldDecorator('remark', {
            rules: [{ required: true, message: '请输入延迟原因!' }],
            initialValue: valueInfo.remark,
          })(<Input.TextArea />)}
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default Form.create()(UpdateStock);
