import React, { useState, forwardRef, useImperativeHandle, useEffect } from 'react';
import { Modal, Timeline, notification, Spin, Collapse } from 'antd';
import { getLogisticsRecord, apiDeliveriesTraceList } from '../services';
import styles from '../index.less';

const { Panel } = Collapse;

const LogisticsRecordModal = (props, ref) => {
  // const { } = props;

  const [visible, setVisible] = useState(false);
  const [loading, setLoading] = useState(false);
  const [dataList, setDataList] = useState([]);

  const getRecordList = async orderNo => {
    const tempObj = {
      detailList: [],
      key: Date.now(),
    };
    setLoading(true);
    const res = await apiDeliveriesTraceList({ orderNo });
    setLoading(false);
    if (!res) {
      notification.info({ message: '暂无物流信息' });
      return;
    }

    setDataList(res.data);
  };

  const open = orderNo => {
    setVisible(true);
    getRecordList(orderNo);
  };
  const onCancel = () => {
    setVisible(false);
    setTimeout(() => {
      setDataList([]);
    }, 1000);
  };
  useImperativeHandle(ref, () => ({
    open,
  }));

  const modalProps = {
    title: '查看物流',
    visible,
    onCancel,
    destroyOnClose: true,
    bodyStyle: { maxHeight: '600px', minHeight: '200px', overflow: 'auto' },
    footer: null,
  };
  const emptyStyle = {
    textAlign: 'center',
    padding: '30px 0',
    color: '#999',
  };

  return (
    <Modal {...modalProps}>
      <Spin spinning={loading}>
        {dataList.length ? (
          dataList.map((dataItem, dataIndex) => (
            <div className={styles['logistics-record']}>
              <div className={styles['logistics-record__topbar']}>包裹{dataIndex + 1}</div>
              <div className={styles['logistics-record__head']}>
                <span className={styles.name}>物流公司：{dataItem.expressCompanyName}</span>
                <span className={styles.no}>物流单号：{dataItem.expressNo}</span>
              </div>
              {dataItem.traceList.map(traceItem => (
                <Timeline>
                  {traceItem?.detailList.length ? (
                    traceItem?.detailList?.map((item, index) => (
                      <Timeline.Item color={index > 0 ? 'gray' : 'blue'} key={index.toString()}>
                        <p>{item.desc}</p>
                        <p>{item.time}</p>
                      </Timeline.Item>
                    ))
                  ) : (
                    <div style={emptyStyle}>暂无物流信息</div>
                  )}
                </Timeline>
              ))}
            </div>
          ))
        ) : (
          <div style={emptyStyle}>暂无物流信息</div>
        )}

        {/* 折叠 */}
        {/* <Collapse defaultActiveKey={['0']} ghost >
          {dataList.length ? (
            dataList.map((dataItem, dataIndex) => (
              <Panel showArrow={false} header={<div className={styles['logistics-record__topbar']}>包裹{dataIndex + 1}</div>} key={dataIndex.toString()}>
              <div className={styles['logistics-record']}>

                <div className={styles['logistics-record__head']}>
                  <span className={styles.name}>物流公司：{dataItem.expressCompanyName}</span>
                  <span className={styles.no}>物流单号：{dataItem.expressNo}</span>
                </div>
                {dataItem.traceList.map(traceItem => (
                  <Timeline>
                    {traceItem?.detailList.length ? (
                      traceItem?.detailList?.map((item, index) => (
                        <Timeline.Item color={index > 0 ? 'gray' : 'blue'} key={index.toString()}>
                          <p>{item.desc}</p>
                          <p>{item.time}</p>
                        </Timeline.Item>
                      ))
                    ) : (
                      <div style={emptyStyle}>暂无物流信息</div>
                    )}
                  </Timeline>
                ))}
              </div>
              </Panel>
            ))
          ) : (
            <div style={emptyStyle}>暂无物流信息</div>
          )}
        </Collapse> */}
      </Spin>
    </Modal>
  );
};

export default forwardRef(LogisticsRecordModal);
