import request from '@/utils/request';
import config from '../../../config/env.config';
// import { stringify } from 'qs';
// import _ from 'lodash';

const { kdspApi } = config;
// const kdspApi = 'http://192.168.29.106:7000';

// 分页查询所有数据
export async function searchList(params, auditStatus) {
  const param = {
    ...params,
    pageIndex: params.current,
    pageSize: params.pageSize || 20,
    auditStatus,
  };
  const data = await request.post('/api/merchants/aftersales/canceledlist', {
    prefix: kdspApi,
    data: param,
  });
  if (data && data.data) {
    return {
      total: data.data.total,
      data: data.data.records,
    };
  }
  return {
    total: 10,
    data: [],
  };
}

// 售后单详情
export async function orderDetail(params) {
  const data = await request.get('/api/merchants/aftersales/skus/canceledlist', {
    prefix: kdspApi,
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data.data || [];
}
// 售后审核
export async function shopAudit(params) {
  return request.post('/api/merchants/aftersales/canceledaudit', {
    data: params,
    prefix: kdspApi,
  });
}

// 审核核检
export async function shopCheck(params) {
  return request.post('/api/merchants/aftersales/check', {
    params,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    prefix: kdspApi,
  });
}
// 查询物流信息
export async function trackInfo(params) {
  const data = await request.get('/api/merchants/deliveries/trace/list', {
    params,
    prefix: kdspApi,
  });
  if (data.businessCode === '0000') {
    return data.data;
  }
  return {};
}
