/* eslint-disable no-param-reassign */
import { Form } from '@ant-design/compatible';

import '@ant-design/compatible/assets/index.css';
import { MinusCircleOutlined, PlusOutlined, RestOutlined } from '@ant-design/icons';
import {
  Modal,
  Table,
  Button,
  Select,
  Input,
  Row,
  Col,
  Checkbox,
  notification,
  Cascader,
  Popover,
  Card,
  Radio,
} from 'antd';
import React, { Component } from 'react';
import SuperSelect from 'antd-virtual-select';
import _ from 'lodash';
import ButtonGroup from './buttonGroup';
import {
  normFile,
  editColumns,
  specValidate,
  dataInit,
  validateSpuInfo,
  createEditData,
} from './mixin';
import { getSpecList, getJdPicList, getBrandList, addGoods, editGoods } from '../service';
import styles from '../style.less';
import Upload from '../../components/sortablUpload';
import BatchSetting from './batchSetting';
import SkuNameChange from './skuNameChange';
import { productTypeList } from '../staticdata';

const FormItem = Form.Item;
const { Option } = Select;
class goodsManage extends Component {
  state = {
    // step: 1,
    // editStep: 1,
    categoryId: null, // 类目选择
    specList: [], // 规格
    normalBrandList: [], // 品牌
    brandList: [], // 虚拟商品的 品牌
    editData: [], // sku表格
    createData: {}, // 返显
    count: -1, // 规格值起始序号+1
    colorImg: {}, // 一级规格是颜色时,color: [imgList]
    initForm: {}, // 返显
    isCancel: false,
    initCascader: null,
    batchDeleteImgObj: {},
    editRow: {},
    editRowIndex: null,
    skuNameVisible: false,
    productType: 1,
    confirmLoading: false,
  };

  componentDidMount() {
    this.getSpecData();
    this.getBrandData();
  }

  componentWillReceiveProps() {
    this.setState({ isCancel: false });
  }

  // 获取规格列表
  getSpecData = async () => {
    try {
      const { data } = await getSpecList();
      if (data) {
        this.setState({ specList: data });
      }
    } catch (e) {
      console.log(e);
    }
  };

  inputChange = (value, key, index) => {
    this.setState(prev => {
      prev.editData[index][key] = value;
      return { editData: prev.editData };
    });
  };

  // eslint-disable-next-line consistent-return
  getJdPicList = async row => {
    //  获取图片需要设置轮播图和详情图
    const {
      form: { setFieldsValue, getFieldsValue },
    } = this.props;
    const { detailImageList = [] } = getFieldsValue(['detailImageList']);
    if (!row.skuLink) {
      return notification.warning({ message: '请输入京东链接再获取图片' });
    }
    const { firstSpecId, firstSpecValue, secondSpecId, secondSpecValue, skuLink } = row;
    const data = await getJdPicList({
      firstSpecId,
      firstSpecValue,
      secondSpecId,
      secondSpecValue,
      skuLink,
      jdSkuInfoUrl: row.skuLink,
    });
    if (!data) return false;
    const detailList = data.detailList || [];
    const { colorImg, editData } = this.state;
    colorImg[data.firstSpecValue] = colorImg[data.firstSpecValue]
      ? colorImg[data.firstSpecValue].concat(data.carouseList || [])
      : data.carouseList || [];
    editData.forEach(i => {
      i.imageList = colorImg[i.firstSpecValue];
      return i;
    });
    console.log(editData);
    this.setState(
      () => ({ colorImg, editData }),
      () => {
        setFieldsValue({
          [`imageList[${data.firstSpecValue}]`]: this.state.colorImg[data.firstSpecValue],
          detailImageList: [...detailImageList, ...detailList],
        });
      },
    );
  };

  changeName = name => {
    const { editData } = this.state;
    editData[this.state.editRowIndex].name = name;
    this.setState({ editData, skuNameVisible: false });
  };

  openSkuNameModal = (row, index) => {
    this.setState({
      editRowIndex: index,
      editRow: row,
      skuNameVisible: true,
    });
  };

  getBrandData = async () => {
    try {
      const { data } = await getBrandList();
      const list = data && data.filter(item => item.name === '虚拟商品');
      this.setState({ normalBrandList: data, brandList: list });
    } catch (e) {
      console.log(e);
    }
  };

  changeStep = () => {
    const {
      form: { setFieldsValue },
      initData,
    } = this.props;
    initData.editData.forEach(item => {
      item.third = item.thirdSkuNo;
    });
    if (Object.keys(initData).length) {
      this.setState({
        initForm: initData,
        editData: initData.editData,
        productType: initData.productType,
      });
      setFieldsValue({
        detailImageList: initData.detailImageList || [],
        imageList: initData.imageList || {},
      });
    }
  };

  //  选择规格
  specChange = (flag, specName) => {
    const { initForm } = this.state;
    if (flag === 'first') {
      initForm.firstSpecName = specName;
      this.setState({ initForm });
      return;
    }
    initForm.secondSpecName = specName;
    this.setState({ initForm });
  };

  treeChange = value => {
    this.setState({ categoryId: value[value.length - 1], initCascader: value });
  };

  remove = (flag, k) => {
    const { form } = this.props;
    const keys = form.getFieldValue(flag);
    if (flag === 'firstKeys') {
      form.setFieldsValue(
        {
          firstKeys: keys.filter(key => key !== k),
        },
        () => {
          const firstKeys = form.getFieldValue('firstKeys');
          const first = form.getFieldValue('first');
          form.setFieldsValue({
            first: _.pick({ first, firstKeys }),
          });
        },
      );
      this.BatchSetting.setFiled(flag);
      return;
    }
    form.setFieldsValue(
      {
        secondKeys: keys.filter(key => key !== k),
      },
      () => {
        const secondKeys = form.getFieldValue('secondKeys');
        const second = form.getFieldValue('second');
        form.setFieldsValue({
          second: _.pick({ second, secondKeys }),
        });
      },
    );
    this.BatchSetting.setFiled(flag);
  };

  add = flag => {
    const { form } = this.props;
    if (flag === 'firstKeys' && !form.getFieldValue('firstSpecId')) {
      notification.error({
        message: '请先选择一级规格数据',
      });
      return;
    }
    if (flag === 'secondKeys' && !form.getFieldValue('secondSpecId')) {
      notification.error({
        message: '请先选择二级规格数据',
      });
      return;
    }
    const keys = form.getFieldValue(flag);
    const nextKeys = keys.concat(+this.state.count + 1);
    this.setState(prev => ({ count: +prev.count + 1 }));
    if (flag === 'firstKeys') {
      form.setFieldsValue({
        firstKeys: nextKeys,
      });
      return;
    }
    form.setFieldsValue({
      secondKeys: nextKeys,
    });
  };

  imgChange = (data, spec) => {
    const { colorImg } = this.state;
    colorImg[spec] = data;
    this.setState({ colorImg });
    this.setState(prev => ({
      editData: prev.editData.map(item => {
        if (`${item.firstSpecValue}` === spec) {
          item.imageList = prev.colorImg[spec];
        }
        return item;
      }),
    }));
  };

  batchSet = editData => {
    this.setState({ editData });
  };

  pullImg = (data, spec) => {
    this.imgChange(data, spec);
    const { form } = this.props;
    form.setFieldsValue({
      [`imageList[${spec}]`]: data,
    });
  };

  createShopInfo = isEdit => {
    const {
      form: { getFieldsValue },
      initData,
    } = this.props;
    const values = getFieldsValue();
    const editData = createEditData(values, initData);
    this.setState({ editData });
  };

  deleteImg = () => {
    const {
      form: { setFieldsValue },
    } = this.props;
    const { batchDeleteImgObj, colorImg, editData } = this.state;
    const deleteKeys = Object.keys(batchDeleteImgObj);
    deleteKeys.map(spec => {
      if (batchDeleteImgObj[spec]) {
        batchDeleteImgObj[spec] = false;
        if (spec === 'detailImageList') {
          setFieldsValue({
            detailImageList: [],
          });
          return false;
        }
        if (spec === 'commonImageList') {
          setFieldsValue({
            commonImageList: [],
          });
          return false;
        }
        colorImg[spec] = [];
        editData.map(item => {
          if (item.firstSpecValue === spec) {
            item.imageList = [];
          }
          return item;
        });
        setFieldsValue({
          [`imageList[${spec}]`]: [],
        });
      }
      return spec;
    });
    this.setState({ colorImg, editData, batchDeleteImgObj });
  };

  chooseRollImg = spec => {
    this.setState(state => {
      state.batchDeleteImgObj[spec] = !state.batchDeleteImgObj[spec];
      return { batchDeleteImgObj: state.batchDeleteImgObj };
    });
  };

  // 最终提交
  confirm = async isContinue => {
    const {
      form: { validateFields },
      initData,
      specListData,
    } = this.props;
    const { editData, productType } = this.state;

    validateFields(async (errors, values) => {
      let imgErr = false;
      if (!errors) {
        if (validateSpuInfo(values, initData, editData, productType)) return;
        editData.forEach(item => {
          item.productStockWarning = item.productStockWarning < 0 ? 0 : item.productStockWarning;
          if (values?.imageList) {
            item.imageList = values?.imageList[item.firstSpecValue] || values.commonImageList;
          } else {
            item.imageList = values.commonImageList || [];
          }
          if (!item.imageList || !item.imageList.length) {
            imgErr = true;
          }
        });
        // 虚拟商品时不校验必 滑动图不全，请检查！
        if (imgErr && productType === 1) {
          notification.error({ message: '滑动图不全，请检查！' });
          return;
        }
        const specs = [];
        specListData.forEach(item => {
          if (values.hasOwnProperty(item.specId)) {
            specs.push({
              specId: item.specId,
              specValues: values[item.specId] || [],
            });
          }
        });
        await this.setState(prev => ({
          confirmLoading: true,
          createData: {
            id: initData.id || '',
            name: values.name,
            items: prev.editData,
            brandId: values.brandId,
            supplierId: null,
            detailImageList: values.detailImageList,
            commonImageList: values.commonImageList || [],
            categoryId: prev.categoryId ? prev.categoryId : initData?.thirdCategoryId,
            // productType: values.productType,
            type: values.productType,
            specs,
            character: values.character,
          },
        }));
        const data = initData.id
          ? await editGoods(this.state.createData)
          : await addGoods(this.state.createData);
        if (data.businessCode === '0000') {
          notification.success({
            message: '商品保存成功！',
          });
          this.props.query();
          if (isContinue) {
            this.setState({
              editData: [], // sku表格
              createData: {}, // 返显
              count: -1, // 规格值起始序号+1
              colorImg: {}, // 一级规格是颜色时，color: [imgList]
              initForm: {}, // 返显
              confirmLoading: false,
              initCascader: null,
            });
            this.props.form.resetFields();
            console.log(this.BatchSetting);
            return;
          }
          this.onCancel();
        }
        this.setState({
          confirmLoading: false,
        });
      }
    });
  };

  onCancel = () => {
    this.setState(
      {
        categoryId: null, // 类目选择
        editData: [], // sku表格
        createData: {}, // 返显
        count: -1, // 规格值起始序号+1
        colorImg: {}, // 一级规格是颜色时，color: [imgList]
        initForm: {}, // 返显
        isCancel: true,
        initCascader: null,
        productType: 1,
      },
      () => {
        this.BatchSetting.formRef.current.resetFields();
        this.props.form.resetFields();
        this.props.onCancel();
      },
    );
  };

  bundleRadioChange = event => {
    this.setState({
      categoryId: null, // 类目选择
      editData: [], // sku表格
      createData: {}, // 返显
      count: -1, // 规格值起始序号+1
      colorImg: {}, // 一级规格是颜色时，color: [imgList]
      initForm: {}, // 返显
      isCancel: true,
      initCascader: null,
      productType: event.target.value,
    });
    this.props.form.resetFields();
    this.BatchSetting.formRef.current.resetFields();
  };

  validateToInputName = (rule, value, callback) => {
    if (value.trim().length < 2) {
      callback(new Error('商品名称不可小于2个字符'));
    }
    callback();
  };

  render() {
    const { visible, form, initData = {}, treeData, virtualTreeData, specListData } = this.props;
    const isEdit = Object.keys(initData).length !== 0;
    // 是否仅编辑卖点和服务
    const isService = initData.state && initData.state !== 4;
    const { getFieldDecorator, getFieldsValue } = form;
    getFieldDecorator('firstKeys', { initialValue: [] });
    getFieldDecorator('secondKeys', { initialValue: [] });
    const { first = [], second, commonImageList, firstKeys, secondKeys, name } = getFieldsValue();
    const isFirstSame = specValidate(first, initData.firstSpecList, initData.id);
    const isSecondSame = specValidate(second, initData.secondSpecList, initData.id);
    if (isFirstSame) first.pop();
    if (isSecondSame) second.pop();
    let colorKeys = isEdit
      ? initData?.firstSpecList?.concat(first || this.state.initForm.first || [])
      : first || this.state.initForm.first || [];

    if (isEdit && !Object.keys(this.state.initForm).length && !this.state.isCancel) {
      this.changeStep(1);
    }
    const isJDGoods = initData.id && initData.pageProductType && +initData.pageProductType !== 1;
    const initCascader = isEdit
      ? [initData.firstCategoryId, initData.secondCategoryId, initData.thirdCategoryId]
      : this.state.initCascader;
    const formItemLayout = {
      labelCol: {
        span: 5,
      },
    };
    const formItemProduct = {
      labelCol: { span: 2 },
      wrapperCol: { span: 22 },
    };
    const { colorImg, productType, normalBrandList, brandList, confirmLoading } = this.state;
    const skuSpeFirstKeys = initData.firstSpecList || [];
    const skuSpeSecondKeys = initData.secondSpecList || [];
    const treeDataArray = productType === 2 ? virtualTreeData : treeData;
    const brandListArray = productType === 2 ? brandList : normalBrandList;
    dataInit(this.state.editData);
    const filterOption = (input, op) => op.props.children.includes(input);

    // ---------------------驳回编辑规格时候，过滤掉colors中为null的数据---------------------
    if (isEdit && !initData.editData[0]?.firstSpec && !initData.editData[0]?.secondSpec) {
      colorKeys = colorKeys.length > 1 ? colorKeys.filter(item => item !== 'null') : colorKeys;
    }
    const optionsWithDisabled = [
      { label: 'Apple', value: 'Apple' },
      { label: 'Pear', value: 'Pear' },
      { label: 'Orange', value: 'Orange', disabled: false },
    ];

    return (
      <Modal
        title={initData.id ? '修改商品' : '新增商品'}
        visible={visible}
        footer={null}
        onCancel={this.onCancel}
        width="1050px"
        bodyStyle={{ background: 'rgb(247 249 249)' }}
      >
        <Form name="horizontal_login">
          <div>
            <Card className={styles.card} bordered={false}>
              <Row type="flex" gutter={24}>
                <Col span={24}>
                  <Form.Item label="商品类型：" {...formItemProduct}>
                    {getFieldDecorator('productType', {
                      initialValue: productType,
                      rules: [{ required: true, message: '请选择商品类型' }],
                    })(
                      <Radio.Group disabled={isEdit || isService} onChange={this.bundleRadioChange}>
                        {productTypeList.map(item => (
                          <Radio key={item.value} value={item.value} disabled={item.disabled}>
                            {item.label}
                          </Radio>
                        ))}
                      </Radio.Group>,
                    )}
                  </Form.Item>
                </Col>
                <Col span={24}>
                  <FormItem label="类目：" {...formItemProduct}>
                    {getFieldDecorator('categoryId', {
                      initialValue: initCascader,
                      rules: [
                        {
                          required: true,
                          message: '请选择类目',
                        },
                      ],
                    })(
                      <Cascader
                        style={{ width: 690 }}
                        changeOnSelect
                        showSearch
                        placeholder="请选择类目，支持模糊搜索"
                        fieldNames={{ label: 'name', value: 'id', children: 'children' }}
                        options={treeDataArray}
                        onChange={(val, label, ext) => this.treeChange(val, label, ext)}
                        disabled={isService}
                      />,
                    )}
                  </FormItem>
                </Col>
              </Row>
            </Card>
            <Card className={styles.card} bordered={false}>
              <Row
                gutter={10}
                style={{ background: '#fff', borderRadius: '6px', padding: '20px 0 5px 0' }}
              >
                <Col span={10}>
                  <FormItem label="商品品牌：" {...formItemLayout}>
                    {getFieldDecorator('brandId', {
                      initialValue: this.state.initForm.brandId,
                      rules: [
                        {
                          required: true,
                          message: '请选择商品品牌',
                        },
                      ],
                    })(
                      <Select
                        allowClear
                        showSearch
                        style={{ width: 280 }}
                        filterOption={filterOption}
                        placeholder="请选择商品品牌，支持模糊搜索"
                        disabled={isService}
                      >
                        {brandListArray?.length &&
                          brandListArray.map(item => (
                            <Option key={item.id} value={item.id}>
                              {item.name}
                            </Option>
                          ))}
                      </Select>,
                    )}
                  </FormItem>
                </Col>
                <span style={{ display: 'inline-block', lineHeight: '35px', color: '#999' }}>
                  若需新增品牌请联系业务员
                </span>
              </Row>
              <Row type="flex">
                <Col span={24}>
                  <Popover content={name} trigger="hover">
                    <FormItem label="商品名称：" labelCol={{ span: 2 }}>
                      {getFieldDecorator('name', {
                        initialValue: initData.name,
                        validateTrigger: ['onBlur'],
                        rules: [
                          {
                            required: true,
                            message: '请输入商品名称',
                          },
                          {
                            validator: this.validateToInputName,
                          },
                        ],
                      })(
                        <Input
                          style={{ width: 690 }}
                          maxLength={100}
                          placeholder="请输入商品名称"
                          allowClear
                          disabled={isService}
                        />,
                      )}
                    </FormItem>
                  </Popover>
                  {isJDGoods && (
                    <div className={styles.warning}>
                      *本列表的商品名称仅供搜索使用，不在前端作展示。若要修改APP端展示的商品名称，请在商品信息中修改。
                    </div>
                  )}
                </Col>
                <Col span={24}>
                  <FormItem label="商品卖点：" labelCol={{ span: 2 }}>
                    {getFieldDecorator('character', {
                      initialValue: initData.character,
                      rules: [
                        {
                          required: true,
                          message: '请输入商品卖点',
                        },
                      ],
                    })(
                      <Input
                        style={{ width: 690 }}
                        maxLength={50}
                        placeholder="卖点最优可填写3个词,12个字。前后用空格加竖杠分隔,例: 莹莹剔透 | 粒粒优选 | 易煮易熟"
                        allowClear
                      />,
                    )}
                  </FormItem>
                </Col>
                {specListData.length
                  ? specListData.map((item, index) => (
                      <Col span={24}>
                        <FormItem label={item.specName} labelCol={{ span: 2 }}>
                          {getFieldDecorator(`${item.specId}`, {
                            initialValue: initData[item.specId],
                          })(<Checkbox.Group options={item.specValues} />)}
                        </FormItem>
                      </Col>
                    ))
                  : ''}
              </Row>
            </Card>
            <Card className={styles.card} bordered={false}>
              <Row>
                <FormItem label="一级规格">
                  {getFieldDecorator('firstSpecId', {
                    initialValue: this.state.initForm.firstSpecId,
                  })(
                    <Select
                      allowClear
                      showSearch
                      style={{ width: 200 }}
                      placeholder="请选择一级规格"
                      disabled={(isEdit && initData.firstSpecId) || isService}
                      onChange={(val, option) =>
                        this.specChange('first', option?.props.children, val)
                      }
                      filterOption={(input, option) =>
                        option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0
                      }
                    >
                      {this.state.specList.length &&
                        this.state.specList.map(item => (
                          <Option value={item.specId} key={item.specId}>
                            {item.specName}
                          </Option>
                        ))}
                    </Select>,
                  )}
                </FormItem>
              </Row>
              <Row type="flex">
                {skuSpeFirstKeys.length > 0 &&
                  skuSpeFirstKeys.map(
                    k =>
                      k !== 'null' && (
                        <Input
                          key={k}
                          value={k}
                          disabled
                          placeholder="请输入规格名称"
                          style={{ width: '15%', margin: 5 }}
                        />
                      ),
                  )}
                {firstKeys.map(k => (
                  <FormItem label="" required={false} key={k}>
                    {getFieldDecorator(`first[${k}]`, {
                      initialValue: this.state.initForm.first && this.state.initForm.first[k],
                      validateTrigger: ['onChange', 'onBlur'],
                      rules: [
                        {
                          required: true,
                          message: '请输入',
                        },
                      ],
                    })(
                      <Input
                        key={k}
                        placeholder="请输入规格名称"
                        style={{ width: '60%', marginRight: 8 }}
                      />,
                    )}
                    {firstKeys.length > 0 ? (
                      <MinusCircleOutlined
                        className="dynamic-delete-button"
                        onClick={() => this.remove('firstKeys', k)}
                      />
                    ) : null}
                  </FormItem>
                ))}
                <FormItem>
                  <Button
                    type="dashed"
                    disabled={isJDGoods}
                    onClick={() => this.add('firstKeys')}
                    style={{ textAlign: 'center' }}
                  >
                    <PlusOutlined />
                  </Button>
                </FormItem>
              </Row>
              <Row>
                <FormItem label="二级规格">
                  {getFieldDecorator('secondSpecId', {
                    initialValue: this.state.initForm.secondSpecId,
                  })(
                    <Select
                      allowClear
                      showSearch
                      disabled={(isEdit && initData.secondSpecId) || isService}
                      placeholder="请选择二级规格"
                      style={{ width: 200 }}
                      onChange={(val, option) => this.specChange('second', option?.props.children)}
                      filterOption={(input, option) =>
                        option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0
                      }
                    >
                      {this.state.specList.length &&
                        this.state.specList.map(item => (
                          <Option key={item.specId} value={item.specId}>
                            {item.specName}
                          </Option>
                        ))}
                    </Select>,
                  )}
                </FormItem>
              </Row>
              <Row type="flex">
                {skuSpeSecondKeys.length > 0 &&
                  skuSpeSecondKeys.map(k => (
                    <Input
                      key={k}
                      value={k}
                      disabled
                      placeholder="请输入规格名称"
                      style={{ width: '15%', margin: 5 }}
                    />
                  ))}
                {secondKeys.map(k => (
                  <FormItem label="" required={false} key={k}>
                    {getFieldDecorator(`second[${k}]`, {
                      initialValue:
                        (this.state.initForm.second && this.state.initForm.second[k]) || '',
                      validateTrigger: ['onChange', 'onBlur'],
                    })(<Input key={k} style={{ width: '60%', marginRight: 8 }} />)}
                    {secondKeys.length > 0 ? (
                      <MinusCircleOutlined
                        className="dynamic-delete-button"
                        onClick={() => this.remove('secondKeys', k)}
                      />
                    ) : null}
                  </FormItem>
                ))}
                <FormItem>
                  <Button
                    type="dashed"
                    onClick={() => this.add('secondKeys')}
                    style={{ textAlign: 'center' }}
                    disabled={isJDGoods}
                  >
                    <PlusOutlined />
                  </Button>
                </FormItem>
              </Row>
            </Card>
            <Row>
              <Button
                type="primary"
                className={styles.logBtn}
                onClick={() => this.createShopInfo(isEdit)}
                disabled={isService}
              >
                生成商品信息
              </Button>
            </Row>
            <BatchSetting
              firstSpes={first ? skuSpeFirstKeys.concat(first) : skuSpeFirstKeys}
              secondSpecs={skuSpeSecondKeys.concat(second || [])}
              onRef={ref => {
                this.BatchSetting = ref;
              }}
              editData={this.state.editData}
              firstSpesName={this.state.initForm.firstSpecName}
              secondSpesName={this.state.initForm.secondSpecName}
              batchSetting={this.batchSet}
              productType={productType}
              isEdit={isEdit}
              isJDGoods={isJDGoods}
              isService={isService}
            />
            <Row>
              <Table
                bordered
                // rowKey={r => r.thirdSkuNo}
                pagination={false}
                scroll={{ y: 300, x: 1200 }}
                dataSource={this.state.editData}
                columns={editColumns(
                  {
                    getJdPicList: this.getJdPicList,
                    inputChange: this.inputChange,
                    openModal: this.openSkuNameModal,
                    productType,
                  },
                  this.state.editData?.length ? this.state.editData[0] : null,
                  this.state.initForm.firstSpecName,
                  this.state.initForm.secondSpecName,
                  isJDGoods,
                  isEdit,
                  isService,
                )}
              />
            </Row>
            <Row>
              <Col span={24}>
                <Button
                  type="danger"
                  size="small"
                  onClick={this.deleteImg}
                  style={{ marginTop: '10px' }}
                  icon={<RestOutlined />}
                >
                  图片批量删除
                </Button>
              </Col>
              <Col span={1}>
                <Checkbox
                  value="commonImageList"
                  checked={this.state.batchDeleteImgObj.commonImageList}
                  style={{ marginTop: '12px' }}
                  onChange={() => this.chooseRollImg('commonImageList')}
                ></Checkbox>
              </Col>
              <Col span={23} className={styles.imgBorder}>
                <p className={styles.ptop}>
                  公共滑动图：
                  <span className={styles.sizeTitle}>（图片最大上传2M）</span>
                </p>
                <FormItem>
                  {getFieldDecorator('commonImageList', {
                    initialValue: this.state.initForm.commonImageList,
                    valuePropName: 'fileList',
                    getValueFromEvent: normFile,
                  })(<Upload isDisabled={isService} />)}
                </FormItem>
              </Col>
              {colorKeys.length > 0 &&
                colorKeys.map(color => {
                  if (JSON.stringify(color) === '{}') return [];
                  if ((color !== null && !color) || (color && !color.trim())) return [];
                  return [
                    <Col span={1}>
                      <Checkbox
                        value={color}
                        checked={this.state.batchDeleteImgObj[color]}
                        style={{ marginTop: '12px' }}
                        onChange={() => this.chooseRollImg(color)}
                      ></Checkbox>
                    </Col>,
                    <Col span={23} className={styles.imgBorder}>
                      <p className={styles.ptop}>
                        {`滑动图${color === 'null' ? '' : `(${color})`}:`}
                        <span className={styles.sizeTitle}>（图片最大上传2M）</span>
                      </p>
                      <FormItem key={color}>
                        {getFieldDecorator(`imageList[${color}]`, {
                          initialValue:
                            this.state.initForm.imageList && this.state.initForm.imageList[color],
                          valuePropName: 'fileList',
                          getValueFromEvent: normFile,
                        })(
                          <Upload
                            isDisabled={isService}
                            onChange={val => this.imgChange(val, color)}
                          />,
                        )}
                        <Button
                          disabled={colorImg[color]?.length}
                          size="small"
                          type="primary"
                          className={styles.pullBtn}
                          onClick={() => this.pullImg(commonImageList, color)}
                        >
                          拉取公共图像
                        </Button>
                      </FormItem>
                    </Col>,
                  ];
                })}
            </Row>
            <Row>
              <Col span={1}>
                <Checkbox
                  value="detailImageList"
                  checked={this.state.batchDeleteImgObj.detailImageList}
                  style={{ marginTop: '12px' }}
                  onChange={() => this.chooseRollImg('detailImageList')}
                ></Checkbox>
              </Col>
              <Col span={23} className={styles.imgBorder}>
                <p className={styles.ptop}>
                  详情图：
                  <span className={styles.sizeTitle}>（图片最大上传2M）</span>
                </p>
                <FormItem>
                  {getFieldDecorator('detailImageList', {
                    initialValue: this.state.initForm.detailImageList,
                    valuePropName: 'fileList',
                    getValueFromEvent: normFile,
                    rules: [
                      {
                        required: productType !== 2,
                        message: '请上传详情图',
                      },
                    ],
                  })(<Upload isDisabled={isService} />)}
                </FormItem>
              </Col>
            </Row>
          </div>
        </Form>
        <ButtonGroup
          key="button-group"
          initData={initData}
          changeStep={this.changeStep}
          onCancel={this.onCancel}
          confirm={this.confirm}
          confirmLoading={confirmLoading}
        ></ButtonGroup>
        <SkuNameChange
          visible={this.state.skuNameVisible}
          data={this.state.editRow.name}
          changeSkuName={data => this.changeName(data)}
          onCancle={() => this.setState({ skuNameVisible: false })}
        ></SkuNameChange>
      </Modal>
    );
  }
}
export default Form.create()(goodsManage);
