// Change theme plugin
// eslint-disable-next-line eslint-comments/abdeils - enable - pair;

/* eslint-disable import/no-extraneous-dependencies */
import ThemeColorReplacer from 'webpack-theme-color-replacer';
import generate from '@ant-design/colors/lib/generate';
import path from 'path';
const SentryPlugin = require('@qg/sentry-webpack-plugin');
const SentryConfig = require('../.sentryclirc');
import webpack from 'webpack';
function getModulePackageName(module) {
  if (!module.context) return null;
  const nodeModulesPath = path.join(__dirname, '../node_modules/');

  if (module.context.substring(0, nodeModulesPath.length) !== nodeModulesPath) {
    return null;
  }

  const moduleRelativePath = module.context.substring(nodeModulesPath.length);
  const [moduleDirName] = moduleRelativePath.split(path.sep);
  let packageName = moduleDirName; // handle tree shaking

  if (packageName && packageName.match('^_')) {
    // eslint-disable-next-line prefer-destructuring
    packageName = packageName.match(/^_(@?[^@]+)/)[1];
  }

  return packageName;
}

export default config => {
  if (process.env.NODE_ENV === 'production') {
    config.plugin('sentry-webpack-plugin').use(SentryPlugin, [SentryConfig]);
    if (process.env.SENTRY_ENV === 'prod') {
      config.plugin('source-map-dev-tool-plugin').use(webpack.SourceMapDevToolPlugin, [
        {
          exclude: /(antdesigns|vendors|mapvgl).*/,
          filename: '[file].map[query]',
        },
      ]);
    }
  }
  // preview.pro.ant.design only do not use in your production;
  if (
    process.env.ANT_DESIGN_PRO_ONLY_DO_NOT_USE_IN_YOUR_PRODUCTION === 'site' ||
    process.env.NODE_ENV !== 'production'
  ) {
    config.plugin('webpack-theme-color-replacer').use(ThemeColorReplacer, [
      {
        fileName: 'css/theme-colors-[contenthash:8].css',
        matchColors: getAntdSerials('#1890ff'),

        // 主色系列
        // 改变样式选择器，解决样式覆盖问题
        changeSelector(selector) {
          switch (selector) {
            case '.ant-calendar-today .ant-calendar-date':
              return ':not(.ant-calendar-selected-date)' + selector;

            case '.ant-btn:focus,.ant-btn:hover':
              return '.ant-btn:focus:not(.ant-btn-primary),.ant-btn:hover:not(.ant-btn-primary)';

            case '.ant-btn.active,.ant-btn:active':
              return '.ant-btn.active:not(.ant-btn-primary),.ant-btn:active:not(.ant-btn-primary)';

            default:
              return selector;
          }
        }, // isJsUgly: true,
      },
    ]);
  } // optimize chunks

  config.optimization // share the same chunks across different modules
    .splitChunks({
      chunks: 'all', //async异步代码分割 initial同步代码分割 all同步异步分割都开启
      automaticNameDelimiter: '.',
      name: true,
      minSize: 30000, // 引入的文件大于30kb才进行分割
      minChunks: 1, // 模块至少使用次数
      cacheGroups: {
        antdesigns: {
          name: 'antdesigns',
          chunks: 'all',
          test: /[\\/]node_modules[\\/](@antv|antd|@ant-design|rc-*|[\\@]ctrl[\\/]tinycolor|tinycolor2)/,
          priority: 10,
        },
        vendors: {
          name: 'vendors',
          chunks: 'all',
          test: /([\\/]node_modules[\\/](lodash|moment|react|dva|postcss|mapbox-gl|date-fns|sentry|react-sortablejs|sortablejs))|([\\/]src[\\/]utils[\\/]qiniu\.min\.js)/,
          priority: 10,
          enforce: true,
        },
        mapvgl: {
          name: 'mapvgl',
          chunks: 'all',
          test: /[\\/]node_modules[\\/](mapvgl|react-bmapgl|react-amap)/,
          priority: 11,
        },
      },
    });
};

const getAntdSerials = color => {
  const lightNum = 9;
  const devide10 = 10; // 淡化（即less的tint）

  const lightens = new Array(lightNum).fill(undefined).map((_, i) => {
    return ThemeColorReplacer.varyColor.lighten(color, i / devide10);
  });
  const colorPalettes = generate(color);
  const rgb = ThemeColorReplacer.varyColor.toNum3(color.replace('#', '')).join(',');
  return lightens.concat(colorPalettes).concat(rgb);
};
