import { stringify } from 'querystring';
import _ from 'lodash';
import request from '@/utils/request';
// import config from '../../../../config/env.config';

export async function query(params) {
  const data = await request.post('/api/kdsp/op/appeal/list', {
    prefix: 'http://yapi.quantgroups.com/mock/351',
    data: stringify(_.omitBy(params, v => !v)),
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  if (data.businessCode === '0000') {
    return { data: data.data.records || [], total: data.data.total };
  }
  return [];
}
export async function getDetail(params) {
  const { data } = await request.post('/api/kdsp/op/appeal/info', {
    data: stringify(_.omitBy(params, v => !v)),
    // prefix: config.kdspApi,
    prefix: 'http://yapi.quantgroups.com/mock/351',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
  });
  return data;
}
