import React, { useState, useRef } from 'react';
import { ProTable } from '@ant-design/pro-components';
import { Button } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { customerColumn } from './staticData';
import CustomerInfo from '@/example/proForm/ModalForm/index';
import utilStyle from '@/utils/utils.less';
import { stringOrObjectTrim } from '@/utils/utils';
import { apiEnterpriseList } from './service';

const BusinessCustomer = () => {
  const refTable = useRef();
  const [visible, setVisible] = useState(false);
  const [id, setId] = useState('');
  const query = async params => {
    const data = {
      page: params.current,
      size: params.pageSize,
      data: stringOrObjectTrim(params),
    };
    const res = await apiEnterpriseList(data);
    return {
      data: res.data.records,
      total: res.data.total,
    };
  };
  const onEdit = v => {
    setId(v);
    setVisible(true);
  };

  const onClose = refresh => {
    console.log(3);
    setVisible(false);
    refresh && refTable.current.reload();
  };

  return (
    <div className={utilStyle.formPageBox}>
      <ProTable
        actionRef={refTable}
        search={{
          span: 8,
          className: utilStyle.formSearch,
          collapsed: false,
          collapseRender: () => null,
        }}
        columns={customerColumn({ onEdit })}
        request={params => query({ ...params })}
        rowKey={r => r.id}
        bordered
        options={false}
        toolBarRender={() => [
          <Button
            key="add"
            icon={<PlusOutlined />}
            type="primary"
            onClick={() => {
              setId('');
              setVisible(!0);
            }}
          >
            添加企业客户
          </Button>,
        ]}
      />
      {visible && <CustomerInfo visible={visible} id={id} onClose={onClose} />}
    </div>
  );
};

export default BusinessCustomer;
