import React, { useState, useEffect } from 'react';
import { Form } from '@ant-design/compatible';
import moment from 'moment';
import {
  Modal,
  Input,
  DatePicker,
  TimePicker,
  Checkbox,
  Cascader,
  Radio,
  notification,
} from 'antd';
import { apiAddrArea, apiCreatStore } from '../services';
import { weekOptions, weekDefault } from '../data';
import MapModal from '@/components/BaiduMap';

const FormItem = Form.Item;
const { RangePicker } = DatePicker;

const StoreModal = props => {
  const {
    visible,
    onCancel,
    form: { getFieldDecorator, getFieldValue, validateFields, resetFields },
    // formData,
  } = props;
  const [areaAddr, setAreaAddr] = useState([]);
  const [formData, setFormData] = useState({});
  const [visibleMap, setVisibleMap] = useState(false);

  const weekD = formData.weekDefault ? formData.weekDefault : weekDefault;

  const handleCancel = isSuccess => {
    resetFields();
    onCancel(isSuccess);
  };
  const handleOk = () => {
    console.log('111 :>> ', 111);
    validateFields(async (error, fieldsValue) => {
      console.log('222 :>> ', 222);
      if (!error) {
        const params = Object.assign({}, fieldsValue);
        const areaArr = ['provinceId', 'cityId', 'countyId', 'townId'];
        if (params.addr && params.addr.forEach) {
          params.addr.forEach((item, i) => {
            params[areaArr[i]] = item;
          });
        }
        if (params.lnglat) {
          const arr = params.lnglat.split(',');
          if (arr.length === 2) {
            params.longitude = arr[0] || '';
            params.latitude = arr[1] || '';
          }
        }
        params.businessHours = {
          weeks: params.week,
          hoursItems: [
            {
              begin: moment(params.time[0]).format('HH:mm'),
              end: moment(params.time[1]).format('HH:mm'),
            },
          ],
        };
        console.log('params :>> ', params);
        const res = await apiCreatStore(params);
        if (res === '0000') {
          notification.success({ message: '创建成功' });
          handleCancel(true);
        }
      }
    });
  };

  const openMap = v => setVisibleMap(v);

  // 获取地址省
  const getAreaAddr = async () => {
    const res = await apiAddrArea();
    console.log('res :>> ', res);
    if (res) {
      const arr = res.map(item => ({
        isLeaf: false,
        loading: false,
        label: item.addrName,
        value: item.addrId,
      }));
      setAreaAddr(arr);
    }
  };

  useEffect(() => {
    if (props.visible) {
      getAreaAddr();
    }
  }, [visible]);

  // 获取市区街道
  const loadData = async selectedOptions => {
    console.log('2222 :>> ', 2222);
    const targetOption = selectedOptions[selectedOptions.length - 1];
    targetOption.loading = true;
    console.log('targetOption.value :>> ', targetOption.value);
    const res = await apiAddrArea({
      parentId: targetOption.value,
    });
    if (res) {
      const children = res.map(item => ({
        isLeaf: +item.addrLevel === 4,
        loading: false,
        label: item.addrName,
        value: item.addrId,
      }));
      targetOption.loading = false;
      if (children.length > 0) {
        targetOption.children = children;
      } else {
        targetOption.isLeaf = true;
      }
      setAreaAddr([...areaAddr]);
    }
  };

  const onSetPoint = e => {
    console.log('e :>> ', e);
    const form = { ...formData };
    form.lnglat = e;
    setFormData(form);
  };

  const layout = {
    labelCol: { span: 6 },
    wrapperCol: { span: 16 },
  };
  return (
    <Modal
      title="门店信息"
      visible={visible}
      width="800px"
      onOk={() => handleOk()}
      onCancel={() => handleCancel()}
    >
      <Form {...layout} name="formData">
        <FormItem label="门店名称" name="name">
          {getFieldDecorator('name', {
            rules: [{ required: true, message: '请输入门店名称!' }],
            initialValue: formData.name,
          })(<Input placeholder="请输入门店名称" maxLength={50} />)}
        </FormItem>
        <FormItem label="门店电话" name="phone">
          {getFieldDecorator('phone', {
            rules: [{ required: true, message: '请输入门店电话!' }],
            initialValue: formData.phone,
          })(<Input placeholder="请输入门店电话" maxLength={20} />)}
        </FormItem>
        <FormItem label="营业时间">
          {getFieldDecorator('time', {
            rules: [{ required: true, message: '请选择营业时间!' }],
            initialValue: formData.time,
          })(
            <div>
              <TimePicker.RangePicker format="HH:mm" />,<TimePicker.RangePicker format="HH:mm" />
            </div>,
          )}
        </FormItem>
        <FormItem label=" ">
          {getFieldDecorator('week', {
            rules: [{ required: true, message: '请选择营业日!' }],
            initialValue: formData.week,
          })(<Checkbox.Group options={weekOptions} defaultValue={weekD} />)}
        </FormItem>
        <FormItem label="店铺区域">
          {getFieldDecorator('addr', {
            rules: [{ required: true, type: 'array', message: '请选择店铺区域!' }],
            initialValue: formData.addr,
          })(<Cascader options={areaAddr} loadData={e => loadData(e)} changeOnSelect />)}
        </FormItem>
        <FormItem label="详细地址">
          {getFieldDecorator('address', {
            rules: [{ required: true, message: '请输入详细地址!' }],
            initialValue: formData.address,
          })(<Input placeholder="请输入详细地址" maxLength={100} />)}
        </FormItem>
        <FormItem label="经纬度">
          {getFieldDecorator('lnglat', {
            rules: [{ required: true, message: '请选择经纬度!' }],
            initialValue: formData.lnglat,
          })(
            <Input
              placeholder="请选择经纬度"
              onClick={() => openMap(true)}
              readOnly
              maxLength={100}
            />,
          )}
        </FormItem>
        <FormItem label="是否启用">
          {getFieldDecorator('state', {
            rules: [{ required: true, message: '请选择是否启用!' }],
            initialValue: formData.state,
          })(
            <Radio.Group>
              <Radio value={1}>是</Radio>
              <Radio value={0}>否</Radio>
            </Radio.Group>,
          )}
        </FormItem>
      </Form>
      <MapModal
        visible={visibleMap}
        onCancel={() => openMap(false)}
        onSetPoint={e => onSetPoint(e)}
      ></MapModal>
    </Modal>
  );
};

export default Form.create()(StoreModal);
