import React, { useState } from 'react';
import { Map, Marker, Icon } from 'react-bmapgl';
import { Modal, Input } from 'antd';

export default props => {
  const { visible, onSetPoint, onCancel } = props;

  const [lnglat, setLnglat] = useState('');

  const handleOk = () => {
    onSetPoint(lnglat);
    onCancel(true);
  };

  const handleCancle = () => onCancel(true);

  const onGetPoint = e => {
    setLnglat(`${e.latlng.lng},${e.latlng.lat}`);
  };

  return (
    <Modal
      title="门店信息"
      visible={visible}
      width="800px"
      onOk={() => handleOk()}
      onCancel={() => handleCancle()}
    >
      <div style={{ marginBottom: '20px' }}>
        <Input value={lnglat} placeholder="点击地图选择经纬度" />
      </div>
      <div style={{ width: '100%', height: '360px' }}>
        <Map
          center={{ lng: 116.404449, lat: 39.914889 }}
          enableScrollWheelZoom
          enableDoubleClickZoom
          onClick={e => onGetPoint(e)}
          zoom={15}
        >
          <Marker
            position={{ lng: 116.404449, lat: 39.914889 }}
            autoViewport
            viewportOptions={{
              zoomFactor: -12,
            }}
          />
        </Map>
      </div>
    </Modal>
  );
};
