import { Button } from 'antd';
import React, { useRef, useState } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import styles from '../index.less';
import ActionModal from './modal';
import { detailQuery } from '../services';

const TableList = props => {
  const [visibleModal, setVisibleModal] = useState(false);
  const [modalValue, setModalValue] = useState({});

  const { batchNo } = props.location.query;

  const actionRef = useRef();

  const reload = () => {
    actionRef.current.reload();
  };
  const onClose = type => {
    if (type) {
      reload();
    }
    setVisibleModal(false);
  };
  const openAction = row => {
    setModalValue(() => row);
    setVisibleModal(true);
  };

  const columns = [
    {
      title: '订单号',
      dataIndex: 'orderNo',
      key: 'orderNo',
      hideInSearch: true,
    },
    {
      title: '京东订单号',
      dataIndex: 'jdOrderId',
      key: 'jdOrderId',
      hideInSearch: true,
    },
    {
      title: '售后单号',
      dataIndex: 'afterServiceNo',
      key: 'afterServiceNo',
      hideInSearch: true,
    },
    {
      title: '我方交易金额',
      dataIndex: 'ownTradeAmount',
      key: 'ownTradeAmount',
      hideInSearch: true,
    },
    {
      title: '三方交易金额',
      dataIndex: 'thirdTradeAmount',
      key: 'thirdTradeAmount',
      hideInSearch: true,
    },
    {
      title: '交易类型',
      dataIndex: 'tradeType',
      key: 'tradeType',
      hideInSearch: true,
      valueEnum: {
        1: '订单支付',
        2: '取消订单退款',
        3: '售后退款',
      },
    },
    {
      title: '交易日期',
      dataIndex: 'tradeDate',
      key: 'tradeDate',
      hideInSearch: true,
    },
    {
      title: '状态',
      dataIndex: 'status',
      key: 'status',
      valueEnum: {
        1: '平',
        2: '不平',
      },
    },
    {
      title: '备注信息',
      dataIndex: 'remarks',
      key: 'remarks',
      hideInSearch: true,
    },
    {
      title: '操作',
      dataIndex: 'townName',
      key: 'townName',
      hideInSearch: true,
      render: (_, row) => [
        <Button
          key="edit"
          type="primary"
          onClick={() => {
            openAction(row);
          }}
        >
          补齐
        </Button>,
      ],
    },
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        className={styles.protable}
        actionRef={actionRef}
        columns={columns}
        params={{ batchNo }}
        request={res => detailQuery(res)}
        rowKey="id"
        bordered
        scroll={{ x: 1500 }}
        search={{
          collapsed: false,
        }}
      />
      <ActionModal visible={visibleModal} formData={modalValue} onClose={onClose}></ActionModal>
    </PageHeaderWrapper>
  );
};

export default TableList;
