import { Tag, Badge } from 'antd';
import React from 'react';

export const appealType = {
  1: '已申诉',
  0: '未申诉',
};
export const columnSticData = [
  {
    title: '售后类型',
    dataIndex: 'serviceType',
    hideInSearch: true,
    width: 120,
    render: serviceType => {
      if (+serviceType === 1) {
        return <span style={{ color: '#ff1616' }}>仅退款</span>;
      }
      return <span>退货退款</span>;
    },
  },
  {
    title: '订单ID',
    dataIndex: 'orderNo',
    hideInTable: true,
    width: 200,
  },
  {
    title: '售后单ID',
    dataIndex: 'serviceNo',
    width: 300,
    render: (serviceNo, r) => (
      <div>
        {r.timeout ? <Tag color="red">{serviceNo}</Tag> : serviceNo}
        {<Badge count={r.reminderFlag ? '催' : ''} size="default" />}
      </div>
    ),
  },
  {
    title: '订单ID',
    dataIndex: 'orderNo',
    hideInSearch: true,
    width: 300,
  },
  {
    title: '售后状态',
    dataIndex: 'dealStatus',
    hideInTable: true,
    valueEnum: {
      0: '待审核',
      10: '三方审核中',
      11: '三方审核通过',
      12: '三方审核拒绝',
      13: '客服审核通过',
      14: '商户审核中',
      15: '商户审核通过',
      16: '商户审核拒绝',
      20: '审核拒绝',
      21: '申诉中',
      30: '待填写退货物流信息',
      40: '待退货入库',
      50: '退货拒收',
      60: '待退款',
      61: '退货处理中',
      70: '售后成功',
      99: '用户取消',
    },
    width: 100,
  },
  {
    title: '售后类型',
    dataIndex: 'type',
    hideInTable: true,
    width: 120,
    valueEnum: {
      1: '仅退款',
      2: '退货退款',
    },
  },

  {
    title: '收货人姓名',
    dataIndex: 'receiverName',
    width: 200,
  },
  {
    title: '收货人手机号',
    dataIndex: 'receiverPhone',
    width: 200,
  },
  {
    title: '收货人地址',
    dataIndex: 'receiveAddress',
    width: 200,
    hideInSearch: true,
  },
  {
    title: '订单开始时间',
    width: 120,
    dataIndex: 'startDate',
    key: 'startDate',
    valueType: 'date',
    hideInTable: true,
  },
  {
    title: '订单结束时间',
    width: 120,
    dataIndex: 'endDate',
    key: 'endDate',
    valueType: 'date',
    hideInTable: true,
  },
  {
    title: '售后原因',
    dataIndex: 'serviceReason',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '售后发生时间',
    dataIndex: 'serviceTime',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '超时时间',
    dataIndex: 'overtime',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '是否催办',
    dataIndex: 'reminderFlag',
    hideInSearch: true,
    width: 120,
    valueEnum: {
      true: '是',
      false: '否',
    },
  },
  {
    title: '是否同意售后',
    dataIndex: 'isAgree',
    hideInSearch: true,
    width: 120,
  },
  {
    title: '拒绝原因',
    dataIndex: 'refuseReason',
    hideInSearch: true,
    width: 200,
  },
];
export const columnPassAudit = [
  ...columnSticData,
  {
    title: '商家退货地址',
    dataIndex: 'merchantAddress',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '退回物流',
    dataIndex: 'expressCompanyName',
    hideInSearch: true,
    width: 150,
  },
  {
    title: '退回物流单号',
    dataIndex: 'deliveryNo',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '售后状态',
    dataIndex: 'serviceStatus',
    hideInSearch: true,
    width: 120,
  },
];
